/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedLongProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;

public class DistributedBaselineConfiguration
implements IgniteChangeGlobalStateSupport {
    private static final int DEFAULT_PERSISTENCE_TIMEOUT = 300000;
    private static final int DEFAULT_IN_MEMORY_TIMEOUT = 0;
    private static final String AUTO_ADJUST_CONFIGURED_MESSAGE = "Baseline auto-adjust is '%s' with timeout='%d' ms";
    private static final String PROPERTY_UPDATE_MESSAGE = "Baseline parameter '%s' was changed from '%s' to '%s'";
    private volatile long dfltTimeout;
    private volatile boolean dfltEnabled;
    private final IgniteLogger log;
    private final DistributedChangeableProperty<Boolean> baselineAutoAdjustEnabled = DistributedBooleanProperty.detachedBooleanProperty("baselineAutoAdjustEnabled", "Value of manual baseline control or auto adjusting baseline. True - If cluster in auto-adjust. False - If cluster in manual.");
    private final DistributedChangeableProperty<Long> baselineAutoAdjustTimeout = DistributedLongProperty.detachedLongProperty("baselineAutoAdjustTimeout", "Number of milliseconds to wait before the actual topology change since last server topology change(node join/left/fail).");

    public DistributedBaselineConfiguration(GridInternalSubscriptionProcessor isp, GridKernalContext ctx, final IgniteLogger log) {
        this.log = log;
        boolean persistenceEnabled = ctx.config() != null && CU.isPersistenceEnabled(ctx.config());
        this.dfltTimeout = persistenceEnabled ? 300000L : 0L;
        this.dfltEnabled = !persistenceEnabled;
        isp.registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            @Override
            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedBaselineConfiguration.this.baselineAutoAdjustEnabled.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedBaselineConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                DistributedBaselineConfiguration.this.baselineAutoAdjustTimeout.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedBaselineConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                dispatcher.registerProperties(new DistributedChangeableProperty[]{DistributedBaselineConfiguration.this.baselineAutoAdjustEnabled, DistributedBaselineConfiguration.this.baselineAutoAdjustTimeout});
            }

            @Override
            public void onReadyToWrite() {
                DistributedConfigurationUtils.setDefaultValue(DistributedBaselineConfiguration.this.baselineAutoAdjustEnabled, DistributedBaselineConfiguration.this.dfltEnabled, log);
                DistributedConfigurationUtils.setDefaultValue(DistributedBaselineConfiguration.this.baselineAutoAdjustTimeout, DistributedBaselineConfiguration.this.dfltTimeout, log);
            }
        });
        isp.registerGlobalStateListener(this);
    }

    public void listenAutoAdjustEnabled(DistributePropertyListener<? super Boolean> lsnr) {
        this.baselineAutoAdjustEnabled.addListener(lsnr);
    }

    public void listenAutoAdjustTimeout(DistributePropertyListener<? super Long> lsnr) {
        this.baselineAutoAdjustTimeout.addListener(lsnr);
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format(AUTO_ADJUST_CONFIGURED_MESSAGE, this.isBaselineAutoAdjustEnabled() ? "enabled" : "disabled", this.getBaselineAutoAdjustTimeout()));
        }
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
    }

    public boolean isBaselineAutoAdjustEnabled() {
        return this.baselineAutoAdjustEnabled.getOrDefault(this.dfltEnabled);
    }

    public GridFutureAdapter<?> updateBaselineAutoAdjustEnabledAsync(boolean baselineAutoAdjustEnabled) throws IgniteCheckedException {
        return this.baselineAutoAdjustEnabled.propagateAsync(!baselineAutoAdjustEnabled, baselineAutoAdjustEnabled);
    }

    public long getBaselineAutoAdjustTimeout() {
        return this.baselineAutoAdjustTimeout.getOrDefault(this.dfltTimeout);
    }

    public GridFutureAdapter<?> updateBaselineAutoAdjustTimeoutAsync(long baselineAutoAdjustTimeout) throws IgniteCheckedException {
        return this.baselineAutoAdjustTimeout.propagateAsync(baselineAutoAdjustTimeout);
    }
}

