/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index;

import org.apache.ignite.internal.cache.query.RangeIndexQueryCriterion;
import org.apache.ignite.internal.cache.query.index.IndexKeyQueryCondition;
import org.apache.ignite.internal.cache.query.index.IndexQueryCriteriaClosure;
import org.apache.ignite.internal.cache.query.index.sorted.IndexPlainRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.jetbrains.annotations.Nullable;

class IndexSingleRangeQuery {
    private final IndexKeyQueryCondition[] keyCond;
    private final IndexKey[] lowerBounds;
    private final IndexKey[] upperBounds;
    private boolean lowerAllNulls = true;
    private boolean upperAllNulls = true;
    @Nullable
    private IndexPlainRowImpl lower;
    @Nullable
    private IndexPlainRowImpl upper;

    IndexSingleRangeQuery(int idxRowSize, int critSize) {
        this.keyCond = new IndexKeyQueryCondition[critSize];
        this.lowerBounds = new IndexKey[idxRowSize];
        this.upperBounds = new IndexKey[idxRowSize];
    }

    BPlusTree.TreeRowClosure<IndexRow, IndexRow> filter(IndexRowComparator rowCmp) {
        if (!(this.keyCond.length <= 1 || this.lowerAllNulls && this.upperAllNulls)) {
            return new IndexQueryCriteriaClosure(this, rowCmp);
        }
        return null;
    }

    IndexKeyQueryCondition keyCondition(int idx) {
        if (idx < this.keyCond.length) {
            return this.keyCond[idx];
        }
        return null;
    }

    void addCondition(IndexKeyQueryCondition cond, int i) {
        this.keyCond[i] = cond;
        if (cond.range() != null) {
            IndexKey l = (IndexKey)cond.range().lower();
            IndexKey u = (IndexKey)cond.range().upper();
            if (l != null) {
                this.lowerAllNulls = false;
            }
            if (u != null) {
                this.upperAllNulls = false;
            }
            this.lowerBounds[i] = l;
            this.upperBounds[i] = u;
        } else {
            this.lowerAllNulls = false;
            this.upperAllNulls = false;
        }
    }

    @Nullable
    IndexPlainRowImpl lower() {
        if (this.lower == null && !this.lowerAllNulls) {
            this.lower = new IndexPlainRowImpl(this.lowerBounds, null);
        }
        return this.lower;
    }

    @Nullable
    IndexPlainRowImpl upper() {
        if (this.upper == null && !this.upperAllNulls) {
            this.upper = new IndexPlainRowImpl(this.upperBounds, null);
        }
        return this.upper;
    }

    boolean inclBoundary(boolean lower) {
        IndexKeyQueryCondition cond;
        RangeIndexQueryCriterion c;
        IndexKeyQueryCondition[] indexKeyQueryConditionArray = this.keyCond;
        int n = indexKeyQueryConditionArray.length;
        for (int i = 0; i < n && (c = (cond = indexKeyQueryConditionArray[i]).range()) != null && (lower ? c.lower() : c.upper()) != null; ++i) {
            if (!lower ? c.upperIncl() : c.lowerIncl()) continue;
            return false;
        }
        return true;
    }
}

