/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import org.treesitter.CleanerRunner;
import org.treesitter.TSException;
import org.treesitter.TSNode;
import org.treesitter.TSParser;
import org.treesitter.TSPoint;
import org.treesitter.TSQuery;
import org.treesitter.TSQueryCapture;
import org.treesitter.TSQueryMatch;
import org.treesitter.TSQueryProgress;

public class TSQueryCursor {
    private final long ptr;
    private final long progressPayloadPtr;
    private boolean executed = false;
    private TSNode node;

    private TSQueryCursor(long ptr, long progressPayloadPtr) {
        this.ptr = ptr;
        this.progressPayloadPtr = progressPayloadPtr;
        CleanerRunner.register(this, new TSQueryCursorCleanAction(ptr, progressPayloadPtr));
    }

    public TSQueryCursor() {
        this(TSParser.ts_query_cursor_new(), TSParser.ts_query_cursor_options_new());
    }

    public void exec(TSQuery query, TSNode node) {
        this.executed = true;
        this.node = node;
        TSParser.ts_query_cursor_exec(this.ptr, query.getPtr(), node);
    }

    public void execWithOptions(TSQuery query, TSNode node, TSQueryProgress progress) {
        this.executed = true;
        this.node = node;
        TSParser.ts_query_cursor_exec_with_options(this.ptr, query.getPtr(), node, progress, this.progressPayloadPtr);
    }

    public boolean didExceedMatchLimit() {
        return TSParser.ts_query_cursor_did_exceed_match_limit(this.ptr);
    }

    public int getMatchLimit() {
        return TSParser.ts_query_cursor_match_limit(this.ptr);
    }

    public void setMatchLimit(int limit) {
        TSParser.ts_query_cursor_set_match_limit(this.ptr, limit);
    }

    @Deprecated
    public void setTimeoutMicros(long timeoutMicros) {
        TSParser.ts_query_cursor_set_timeout_micros(this.ptr, timeoutMicros);
    }

    @Deprecated
    public long getTimeoutMicros() {
        return TSParser.ts_query_cursor_timeout_micros(this.ptr);
    }

    public boolean setByteRange(int startByte, int endByte) {
        return TSParser.ts_query_cursor_set_byte_range(this.ptr, startByte, endByte);
    }

    public boolean setPointRange(TSPoint startPoint, TSPoint endPoint) {
        return TSParser.ts_query_cursor_set_point_range(this.ptr, startPoint, endPoint);
    }

    public boolean nextMatch(TSQueryMatch match) {
        this.assertExecuted();
        boolean ret = TSParser.ts_query_cursor_next_match(this.ptr, match);
        this.addTsTreeRef(match);
        return ret;
    }

    public void removeMatch(int matchId) {
        TSParser.ts_query_cursor_remove_match(this.ptr, matchId);
    }

    public boolean nextCapture(TSQueryMatch match) {
        this.assertExecuted();
        boolean ret = TSParser.ts_query_cursor_next_capture(this.ptr, match);
        this.addTsTreeRef(match);
        return ret;
    }

    private void addTsTreeRef(TSQueryMatch match) {
        if (match.getCaptures() != null) {
            for (TSQueryCapture capture : match.getCaptures()) {
                if (capture.getNode() == null) continue;
                capture.getNode().setTree(this.node.getTree());
            }
        }
    }

    private void assertExecuted() {
        if (!this.executed) {
            throw new TSException("Query not executed, call exec() first.");
        }
    }

    public TSMatchIterator getMatches() {
        return new TSMatchIterator(TSParser::ts_query_cursor_next_match);
    }

    public TSMatchIterator getCaptures() {
        return new TSMatchIterator(TSParser::ts_query_cursor_next_capture);
    }

    public class TSMatchIterator
    implements Iterator<TSQueryMatch> {
        private TSQueryMatch tempMatch = null;
        private TSQueryMatch lastMatch = null;
        private BiFunction<Long, TSQueryMatch, Boolean> nextFunction;

        public TSMatchIterator(BiFunction<Long, TSQueryMatch, Boolean> nextFunction) {
            this.nextFunction = nextFunction;
        }

        private TSQueryMatch nextMatch() {
            TSQueryCursor.this.assertExecuted();
            TSQueryMatch match = new TSQueryMatch();
            boolean ret = this.nextFunction.apply(TSQueryCursor.this.ptr, match);
            if (ret) {
                TSQueryCursor.this.addTsTreeRef(match);
                return match;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            TSQueryMatch match = this.nextMatch();
            if (match != null) {
                this.tempMatch = match;
                return true;
            }
            return false;
        }

        @Override
        public TSQueryMatch next() {
            if (this.tempMatch != null) {
                TSQueryMatch newMatch = this.tempMatch;
                this.tempMatch = null;
                return newMatch;
            }
            TSQueryMatch match = this.nextMatch();
            if (match != null) {
                this.lastMatch = match;
                return match;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastMatch == null) {
                throw new IllegalStateException();
            }
            TSParser.ts_query_cursor_remove_match(TSQueryCursor.this.ptr, this.tempMatch.getId());
        }
    }

    private static class TSQueryCursorCleanAction
    implements Runnable {
        private final long ptr;
        private final long optionsPtr;

        public TSQueryCursorCleanAction(long ptr, long optionsPtr) {
            this.ptr = ptr;
            this.optionsPtr = optionsPtr;
        }

        @Override
        public void run() {
            TSParser.ts_query_cursor_delete(this.ptr);
            TSParser.ts_query_cursor_options_delete(this.optionsPtr);
        }
    }
}

