/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.commands.Options;
import org.apache.ignite.internal.cli.core.repl.completer.CompleterConf;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompleterRegistry;
import org.apache.ignite.internal.cli.core.repl.completer.cli.CliConfigDynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.cluster.ClusterUrlDynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.filter.ExclusionsCompleterFilter;
import org.apache.ignite.internal.cli.core.repl.completer.hocon.ClusterConfigDynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.hocon.NodeConfigDynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.jdbc.JdbcUrlDynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.metric.MetricSourceDynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.node.NodeNameDynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.path.FilePathCompleter;
import org.apache.ignite.internal.cli.core.repl.completer.unit.UnitIdDynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.unit.UnitNodesCompleterFilter;
import org.apache.ignite.internal.cli.core.repl.completer.unit.UnitNodesDynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.unit.UnitVersionsDynamicCompleterFactory;

@Singleton
public class DynamicCompleterActivationPoint {
    @Inject
    private NodeNameDynamicCompleterFactory nodeNameDynamicCompleterFactory;
    @Inject
    private ClusterConfigDynamicCompleterFactory clusterConfigDynamicCompleterFactory;
    @Inject
    private NodeConfigDynamicCompleterFactory nodeConfigDynamicCompleterFactory;
    @Inject
    private ClusterUrlDynamicCompleterFactory clusterUrlDynamicCompleterFactory;
    @Inject
    private JdbcUrlDynamicCompleterFactory jdbcUrlDynamicCompleterFactory;
    @Inject
    private UnitIdDynamicCompleterFactory unitIdDynamicCompleterFactory;
    @Inject
    private UnitVersionsDynamicCompleterFactory unitVersionsDynamicCompleterFactory;
    @Inject
    private UnitNodesDynamicCompleterFactory unitNodesDynamicCompleterFactory;
    @Inject
    private CliConfigDynamicCompleterFactory cliConfigDynamicCompleterFactory;
    @Inject
    private MetricSourceDynamicCompleterFactory metricSourceDynamicCompleterFactory;

    public void activateDynamicCompleter(DynamicCompleterRegistry registry) {
        registry.register(CompleterConf.builder().command("cluster", "config", "show").command("cluster", "config", "update").singlePositionalParameter().build(), this.clusterConfigDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("node", "config", "show").singlePositionalParameter().build(), this.nodeConfigDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("node", "config", "update").singlePositionalParameter().filter(new ExclusionsCompleterFilter("ignite.compute", "ignite.raft")).build(), this.nodeConfigDynamicCompleterFactory);
        registry.register(CompleterConf.builder().enableOptions(Options.NODE_NAME).exclusiveEnableOptions().build(), this.nodeNameDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("cluster", "init").enableOptions(Options.META_STORAGE_NODE_NAME, Options.CMG_NODE_NAME).build(), this.nodeNameDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("sql").enableOptions(Options.SCRIPT_FILE).exclusiveEnableOptions().build(), words -> new FilePathCompleter());
        registry.register(CompleterConf.builder().command("sql").enableOptions(Options.JDBC_URL).exclusiveEnableOptions().build(), this.jdbcUrlDynamicCompleterFactory);
        registry.register(CompleterConf.builder().enableOptions(Options.CLUSTER_URL, Options.NODE_URL).exclusiveEnableOptions().build(), this.clusterUrlDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("cli", "config", "set").command("cli", "config", "get").command("cli", "config", "remove").singlePositionalParameter().build(), this.cliConfigDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("cluster", "unit", "deploy").enableOptions(Options.UNIT_PATH).exclusiveEnableOptions().build(), words -> new FilePathCompleter());
        registry.register(CompleterConf.builder().command("cluster", "unit", "deploy").enableOptions(Options.UNIT_NODES).filter(new UnitNodesCompleterFilter()).exclusiveEnableOptions().build(), this.unitNodesDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("cluster", "unit", "undeploy").command("cluster", "unit", "status").command("cluster", "unit", "list").command("node", "unit", "list").singlePositionalParameter().build(), this.unitIdDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("cluster", "unit", "undeploy").command("cluster", "unit", "list").command("node", "unit", "list").enableOptions(Options.UNIT_VERSION).exclusiveEnableOptions().build(), this.unitVersionsDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("node", "metric", "source", "enable").command("node", "metric", "source", "disable").singlePositionalParameter().build(), this.metricSourceDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("recovery", "partitions", "states").enableOptions(Options.RECOVERY_NODE_NAMES).build(), this.nodeNameDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("recovery", "partitions", "restart").enableOptions(Options.RECOVERY_NODE_NAMES).build(), this.nodeNameDynamicCompleterFactory);
        registry.register(CompleterConf.builder().command("recovery", "cluster", "reset").enableOptions(Options.RECOVERY_CMG_NODES).build(), this.nodeNameDynamicCompleterFactory);
    }
}

