/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar.wrapped;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import me.tongfei.progressbar.ProgressBar;

public class ProgressBarWrappedWriter
extends FilterWriter {
    private ProgressBar pb;

    public ProgressBarWrappedWriter(Writer out, ProgressBar pb) {
        super(out);
        this.pb = pb;
    }

    @Override
    public void write(int c) throws IOException {
        this.out.write(c);
        this.pb.step();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
        this.pb.stepBy(len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.out.write(str, off, len);
        this.pb.stepBy(len);
    }

    @Override
    public void write(String str) throws IOException {
        this.out.write(str);
        this.pb.stepBy(str.length());
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        this.pb.refresh();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.pb.close();
    }
}

