/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import me.tongfei.progressbar.ProgressBarConsumer;
import me.tongfei.progressbar.ProgressBarRenderer;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.TerminalUtils;

class ProgressUpdateAction
implements Runnable {
    ProgressState progress;
    private ProgressBarRenderer renderer;
    private ProgressBarConsumer consumer;
    private boolean continuousUpdate;
    private boolean clearDisplayOnFinish;
    private volatile long last;
    private volatile boolean first;

    ProgressUpdateAction(ProgressState progress, ProgressBarRenderer renderer, ProgressBarConsumer consumer, boolean continuousUpdate, boolean clearDisplayOnFinish) {
        this.progress = progress;
        this.renderer = renderer;
        this.consumer = consumer;
        this.continuousUpdate = continuousUpdate;
        this.clearDisplayOnFinish = clearDisplayOnFinish;
        this.last = progress.start;
        this.first = true;
    }

    void refresh() {
        if (this.continuousUpdate || this.progress.current > this.last) {
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        String rendered = this.renderer.render(this.progress, this.consumer.getMaxRenderedLength());
        this.consumer.accept(rendered);
        this.last = this.progress.current;
    }

    @Override
    public void run() {
        if (this.first) {
            this.forceRefresh();
            this.first = false;
        } else {
            if (!this.progress.paused) {
                this.refresh();
            }
            if (!this.progress.alive) {
                this.forceRefresh();
                if (this.clearDisplayOnFinish) {
                    this.consumer.clear();
                }
                this.consumer.close();
                TerminalUtils.closeTerminal();
            }
        }
    }
}

