/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricProvider;
import org.apache.ignite.internal.metrics.MetricRegistry;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.metrics.configuration.MetricConfiguration;
import org.apache.ignite.internal.metrics.configuration.MetricView;
import org.apache.ignite.internal.metrics.exporters.MetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.ExporterView;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.VisibleForTesting;

public class MetricManagerImpl
implements MetricManager {
    private final IgniteLogger log;
    private final MetricRegistry registry;
    private final MetricProvider metricsProvider;
    private final Map<String, MetricExporter> enabledMetricExporters = new ConcurrentHashMap<String, MetricExporter>();
    private Map<String, MetricExporter> availableExporters;
    private MetricConfiguration metricConfiguration;
    private Supplier<UUID> clusterIdSupplier;
    private String nodeName;

    public MetricManagerImpl() {
        this(Loggers.forClass(MetricManagerImpl.class));
    }

    public MetricManagerImpl(IgniteLogger log) {
        this.registry = new MetricRegistry();
        this.metricsProvider = new MetricProvider(this.registry);
        this.log = log;
    }

    @Override
    public void configure(MetricConfiguration metricConfiguration, Supplier<UUID> clusterIdSupplier, String nodeName) {
        assert (this.metricConfiguration == null) : "Metric manager must be configured only once, on the start of the node";
        assert (this.clusterIdSupplier == null) : "Metric manager must be configured only once, on the start of the node";
        assert (this.nodeName == null) : "Metric manager must be configured only once, on the start of the node";
        this.metricConfiguration = metricConfiguration;
        this.clusterIdSupplier = clusterIdSupplier;
        this.nodeName = nodeName;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.start(MetricManagerImpl.loadExporters());
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    @VisibleForTesting
    public void start(Map<String, MetricExporter> availableExporters) {
        this.availableExporters = availableExporters;
        MetricView conf = (MetricView)this.metricConfiguration.value();
        for (ExporterView exporter : conf.exporters()) {
            this.checkAndStartExporter(exporter.exporterName(), exporter);
        }
        this.metricConfiguration.exporters().listenElements((ConfigurationNamedListListener)new ExporterConfigurationListener());
    }

    @Override
    public void start(Iterable<MetricExporter<?>> exporters) {
        this.availableExporters = new HashMap<String, MetricExporter>();
        for (MetricExporter<?> exporter : exporters) {
            exporter.start(this.metricsProvider, null, this.clusterIdSupplier, this.nodeName);
            this.availableExporters.put(exporter.name(), exporter);
            this.enabledMetricExporters.put(exporter.name(), exporter);
        }
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        for (MetricExporter metricExporter : this.enabledMetricExporters.values()) {
            metricExporter.stop();
        }
        this.enabledMetricExporters.clear();
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public void registerSource(MetricSource src) {
        this.registry.registerSource(src);
    }

    @Override
    public void unregisterSource(MetricSource src) {
        this.registry.unregisterSource(src);
    }

    @Override
    public void unregisterSource(String srcName) {
        this.registry.unregisterSource(srcName);
    }

    @Override
    public MetricSet enable(MetricSource src) {
        MetricSet enabled = this.registry.enable(src);
        if (enabled != null) {
            this.enabledMetricExporters.values().forEach(e -> e.addMetricSet(enabled));
        }
        return enabled;
    }

    @Override
    public MetricSet enable(String srcName) {
        MetricSet enabled = this.registry.enable(srcName);
        if (enabled != null) {
            this.enabledMetricExporters.values().forEach(e -> e.addMetricSet(enabled));
        }
        return enabled;
    }

    @Override
    public void disable(MetricSource src) {
        this.registry.disable(src);
        this.enabledMetricExporters.values().forEach(e -> e.removeMetricSet(src.name()));
    }

    @Override
    public void disable(String srcName) {
        this.registry.disable(srcName);
        this.enabledMetricExporters.values().forEach(e -> e.removeMetricSet(srcName));
    }

    @Override
    public IgniteBiTuple<Map<String, MetricSet>, Long> metricSnapshot() {
        return this.registry.metricSnapshot();
    }

    @Override
    public Collection<MetricSource> metricSources() {
        return this.registry.metricSources();
    }

    private <T extends ExporterView> void checkAndStartExporter(String exporterName, T exporterConfiguration) {
        MetricExporter exporter = this.availableExporters.get(exporterName);
        if (exporter != null) {
            this.enabledMetricExporters.computeIfAbsent(exporter.name(), name -> {
                try {
                    exporter.start(this.metricsProvider, exporterConfiguration, this.clusterIdSupplier, this.nodeName);
                    return exporter;
                }
                catch (Exception e) {
                    this.log.warn("Unable to start metrics exporter name=[" + exporterName + "].", (Throwable)e);
                    return null;
                }
            });
        } else {
            this.log.warn("Received configuration for unknown metric exporter with the name '" + exporterName + "'", new Object[0]);
        }
    }

    public static Map<String, MetricExporter> loadExporters() {
        ClassLoader clsLdr = Thread.currentThread().getContextClassLoader();
        return ServiceLoader.load(MetricExporter.class, clsLdr).stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(e -> e.name(), Function.identity()));
    }

    private class ExporterConfigurationListener
    implements ConfigurationNamedListListener<ExporterView> {
        private ExporterConfigurationListener() {
        }

        public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<ExporterView> ctx) {
            MetricManagerImpl.this.checkAndStartExporter(((ExporterView)ctx.newValue()).exporterName(), (ExporterView)ctx.newValue());
            return CompletableFutures.nullCompletedFuture();
        }

        public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<ExporterView> ctx) {
            MetricExporter removed = MetricManagerImpl.this.enabledMetricExporters.remove(((ExporterView)ctx.oldValue()).exporterName());
            if (removed != null) {
                removed.stop();
            }
            return CompletableFutures.nullCompletedFuture();
        }

        public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<ExporterView> ctx) {
            MetricExporter exporter = MetricManagerImpl.this.enabledMetricExporters.get(((ExporterView)ctx.newValue()).exporterName());
            if (exporter != null) {
                exporter.reconfigure((ExporterView)ctx.newValue());
            }
            return CompletableFutures.nullCompletedFuture();
        }
    }
}

