/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.apache.hc.core5.http.io.entity.EmptyInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicHttpEntity {
    TestBasicHttpEntity() {
    }

    @Test
    void testBasics() {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        BasicHttpEntity httpentity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, null);
        Assertions.assertEquals((long)bytes.length, (long)httpentity.getContentLength());
        Assertions.assertFalse((boolean)httpentity.isRepeatable());
        Assertions.assertTrue((boolean)httpentity.isStreaming());
    }

    @Test
    void testConstructorNullContent() {
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, ContentType.APPLICATION_ATOM_XML));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, ContentType.APPLICATION_ATOM_XML, false));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, null, false));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, ContentType.APPLICATION_ATOM_XML, ""));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, null, ""));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, 0L, ContentType.APPLICATION_ATOM_XML));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, 0L, null));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, 0L, ContentType.APPLICATION_ATOM_XML, ""));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, 0L, null, ""));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, 0L, ContentType.APPLICATION_ATOM_XML, "", false));
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpEntity(null, 0L, null, "", false));
    }

    @Test
    void testToString() throws Exception {
        try (BasicHttpEntity httpentity = new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, 10L, ContentType.parseLenient((CharSequence)"blah"), "yada", true);){
            Assertions.assertEquals((Object)"[Entity-Class: BasicHttpEntity, Content-Type: blah, Content-Encoding: yada, chunked: true]", (Object)httpentity.toString());
        }
    }

    @Test
    void testWriteTo() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        BasicHttpEntity httpentity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, ContentType.TEXT_PLAIN);
        Assertions.assertFalse((boolean)httpentity.isRepeatable());
        Assertions.assertTrue((boolean)httpentity.isStreaming());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] bytes2 = out.toByteArray();
        Assertions.assertNotNull((Object)bytes2);
        Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
        for (int i = 0; i < bytes.length; ++i) {
            Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
        }
    }
}

