/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.RandomNumber;
import org.ojalgo.scalar.PrimitiveScalar;

public class Gamma
extends RandomNumber {
    private static final long serialVersionUID = 6544837857838057678L;
    private final double myShape;
    private final double myRate;

    public Gamma() {
        this(PrimitiveMath.ONE, PrimitiveMath.ONE);
    }

    public Gamma(double aShape, double aRate) {
        this.myShape = aShape;
        this.myRate = aRate;
    }

    @Override
    public double getExpected() {
        return this.myShape / this.myRate;
    }

    @Override
    public double getVariance() {
        return this.myShape / (this.myRate * this.myRate);
    }

    @Override
    protected double generate() {
        int tmpInteger = (int)this.myShape;
        double tmpFraction = this.myShape - (double)tmpInteger;
        double tmpIntegralPart = PrimitiveMath.ZERO;
        for (int i = 0; i < tmpInteger; ++i) {
            tmpIntegralPart -= PrimitiveFunction.LOG.invoke(this.random().nextDouble());
        }
        double tmpFractionalPart = PrimitiveMath.ZERO;
        if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpFraction)) {
            double tmpDenom;
            double tmpNumer;
            double tmpFractionMinusOne = tmpFraction - PrimitiveMath.ONE;
            do {
                tmpFractionalPart = -PrimitiveMath.TWO * PrimitiveFunction.LOG.invoke(PrimitiveMath.ONE - PrimitiveFunction.POW.invoke(this.random().nextDouble(), PrimitiveMath.ONE / tmpFraction));
                double tmpNegHalfFraction = -tmpFractionalPart / PrimitiveMath.TWO;
                tmpNumer = PrimitiveFunction.POW.invoke(tmpFractionalPart, tmpFractionMinusOne) * PrimitiveFunction.EXP.invoke(tmpNegHalfFraction);
                tmpDenom = PrimitiveFunction.POW.invoke(PrimitiveMath.TWO, tmpFractionMinusOne) * PrimitiveFunction.POW.invoke(-PrimitiveFunction.EXPM1.invoke(tmpNegHalfFraction), tmpFractionMinusOne);
            } while (this.random().nextDouble() > tmpNumer / tmpDenom);
        }
        return (tmpIntegralPart + tmpFractionalPart) / this.myRate;
    }
}

