/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationRequestsInfo;

@XmlRootElement(name="reservation-definition")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ReservationDefinitionInfo {
    @XmlElement(name="arrival")
    private long arrival;
    @XmlElement(name="deadline")
    private long deadline;
    @XmlElement(name="reservation-requests")
    private ReservationRequestsInfo reservationRequests;
    @XmlElement(name="reservation-name")
    private String reservationName;
    @XmlElement(name="priority")
    private int priority;
    @XmlElement(name="recurrence-expression")
    private String recurrenceExpression;

    public ReservationDefinitionInfo() {
    }

    public ReservationDefinitionInfo(ReservationDefinition definition) {
        this.arrival = definition.getArrival();
        this.deadline = definition.getDeadline();
        this.reservationName = definition.getReservationName();
        this.reservationRequests = new ReservationRequestsInfo(definition.getReservationRequests());
        this.recurrenceExpression = definition.getRecurrenceExpression();
    }

    public long getArrival() {
        return this.arrival;
    }

    public void setArrival(long arrival) {
        this.arrival = arrival;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(long deadline) {
        this.deadline = deadline;
    }

    public ReservationRequestsInfo getReservationRequests() {
        return this.reservationRequests;
    }

    public void setReservationRequests(ReservationRequestsInfo reservationRequests) {
        this.reservationRequests = reservationRequests;
    }

    public String getReservationName() {
        return this.reservationName;
    }

    public void setReservationName(String reservationName) {
        this.reservationName = reservationName;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getRecurrenceExpression() {
        return this.recurrenceExpression;
    }

    public void setRecurrenceExpression(String recurrenceExpression) {
        this.recurrenceExpression = recurrenceExpression;
    }
}

