/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore;

import com.microsoft.azure.cosmosdb.ConnectionPolicy;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.rx.AsyncDocumentClient;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowActivityEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEventSubDoc;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineMetricSubDoc;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreVendor;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelinePrefixFilter;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineStorageUtils;

public final class DocumentStoreUtils {
    private static final long MILLIS_ONE_DAY = 86400000L;
    private static final String TIMELINE_STORE_TYPE = "yarn.timeline-service.document-store-type";
    static final String TIMELINE_SERVICE_COSMOSDB_ENDPOINT = "yarn.timeline-service.document-store.cosmos-db.endpoint";
    static final String TIMELINE_SERVICE_COSMOSDB_MASTER_KEY = "yarn.timeline-service.document-store.cosmos-db.masterkey";
    static final String TIMELINE_SERVICE_DOCUMENTSTORE_DATABASE_NAME = "yarn.timeline-service.document-store.db-name";
    private static final String DEFAULT_TIMELINE_SERVICE_DOCUMENTSTORE_DATABASE_NAME = "timeline_service";

    private DocumentStoreUtils() {
    }

    public static void validateCosmosDBConf(Configuration conf) throws YarnException {
        if (conf == null) {
            throw new NullPointerException("Configuration cannot be null");
        }
        if (DocumentStoreUtils.isNullOrEmpty(conf.get(TIMELINE_SERVICE_COSMOSDB_ENDPOINT), conf.get(TIMELINE_SERVICE_COSMOSDB_MASTER_KEY))) {
            throw new YarnException("One or more CosmosDB configuration property is missing in yarn-site.xml");
        }
    }

    public static DocumentStoreVendor getStoreVendor(Configuration conf) {
        return DocumentStoreVendor.getStoreType(conf.get(TIMELINE_STORE_TYPE, DocumentStoreVendor.COSMOS_DB.name()));
    }

    public static TimelineEvent fetchEvent(TimelineEntity timelineEntity, String eventType) {
        for (TimelineEvent event : timelineEntity.getEvents()) {
            if (!event.getId().equals(eventType)) continue;
            return event;
        }
        return null;
    }

    public static boolean isNullOrEmpty(String ... values) {
        if (values == null || values.length == 0) {
            return true;
        }
        for (String value : values) {
            if (value != null && !value.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static AsyncDocumentClient createCosmosDBAsyncClient(Configuration conf) {
        return new AsyncDocumentClient.Builder().withServiceEndpoint(DocumentStoreUtils.getCosmosDBEndpoint(conf)).withMasterKeyOrResourceToken(DocumentStoreUtils.getCosmosDBMasterKey(conf)).withConnectionPolicy(ConnectionPolicy.GetDefault()).withConsistencyLevel(ConsistencyLevel.Session).build();
    }

    public static long getTopOfTheDayTimestamp(long timeStamp) {
        return timeStamp - timeStamp % 86400000L;
    }

    public static String constructTimelineEntityDocId(TimelineCollectorContext collectorContext, String type) {
        return String.format("%s!%s!%s!%d!%s!%s", collectorContext.getClusterId(), collectorContext.getUserId(), collectorContext.getFlowName(), collectorContext.getFlowRunId(), collectorContext.getAppId(), type);
    }

    public static String constructTimelineEntityDocId(TimelineCollectorContext collectorContext, String type, String id) {
        return String.format("%s!%s!%s!%d!%s!%s!%s", collectorContext.getClusterId(), collectorContext.getUserId(), collectorContext.getFlowName(), collectorContext.getFlowRunId(), collectorContext.getAppId(), type, id);
    }

    public static String constructFlowRunDocId(TimelineCollectorContext collectorContext) {
        return String.format("%s!%s!%s!%s", collectorContext.getClusterId(), collectorContext.getUserId(), collectorContext.getFlowName(), collectorContext.getFlowRunId());
    }

    public static String constructFlowActivityDocId(TimelineCollectorContext collectorContext, long eventTimestamp) {
        return String.format("%s!%s!%s!%s", collectorContext.getClusterId(), DocumentStoreUtils.getTopOfTheDayTimestamp(eventTimestamp), collectorContext.getUserId(), collectorContext.getFlowName());
    }

    private static String getCosmosDBEndpoint(Configuration conf) {
        return conf.get(TIMELINE_SERVICE_COSMOSDB_ENDPOINT);
    }

    private static String getCosmosDBMasterKey(Configuration conf) {
        return conf.get(TIMELINE_SERVICE_COSMOSDB_MASTER_KEY);
    }

    public static String getCosmosDBDatabaseName(Configuration conf) {
        return conf.get(TIMELINE_SERVICE_DOCUMENTSTORE_DATABASE_NAME, DocumentStoreUtils.getDefaultTimelineServiceDBName(conf));
    }

    private static String getDefaultTimelineServiceDBName(Configuration conf) {
        return DocumentStoreUtils.getClusterId(conf) + "_" + DEFAULT_TIMELINE_SERVICE_DOCUMENTSTORE_DATABASE_NAME;
    }

    private static String getClusterId(Configuration conf) {
        return conf.get("yarn.resourcemanager.cluster-id", "yarn_cluster");
    }

    private static boolean isTimeInRange(long time, long timeBegin, long timeEnd) {
        return time >= timeBegin && time <= timeEnd;
    }

    static boolean isFilterNotMatching(TimelineEntityFilters filters, TimelineEntity timelineEntity) throws IOException {
        if (timelineEntity.getCreatedTime() != null && !DocumentStoreUtils.isTimeInRange(timelineEntity.getCreatedTime(), filters.getCreatedTimeBegin(), filters.getCreatedTimeEnd())) {
            return true;
        }
        if (filters.getRelatesTo() != null && !filters.getRelatesTo().getFilterList().isEmpty() && !TimelineStorageUtils.matchRelatesTo((TimelineEntity)timelineEntity, (TimelineFilterList)filters.getRelatesTo())) {
            return true;
        }
        if (filters.getIsRelatedTo() != null && !filters.getIsRelatedTo().getFilterList().isEmpty() && !TimelineStorageUtils.matchIsRelatedTo((TimelineEntity)timelineEntity, (TimelineFilterList)filters.getIsRelatedTo())) {
            return true;
        }
        if (filters.getInfoFilters() != null && !filters.getInfoFilters().getFilterList().isEmpty() && !TimelineStorageUtils.matchInfoFilters((TimelineEntity)timelineEntity, (TimelineFilterList)filters.getInfoFilters())) {
            return true;
        }
        if (filters.getConfigFilters() != null && !filters.getConfigFilters().getFilterList().isEmpty() && !TimelineStorageUtils.matchConfigFilters((TimelineEntity)timelineEntity, (TimelineFilterList)filters.getConfigFilters())) {
            return true;
        }
        if (filters.getMetricFilters() != null && !filters.getMetricFilters().getFilterList().isEmpty() && !TimelineStorageUtils.matchMetricFilters((TimelineEntity)timelineEntity, (TimelineFilterList)filters.getMetricFilters())) {
            return true;
        }
        return filters.getEventFilters() != null && !filters.getEventFilters().getFilterList().isEmpty() && !TimelineStorageUtils.matchEventFilters((TimelineEntity)timelineEntity, (TimelineFilterList)filters.getEventFilters());
    }

    public static TimelineEntity createEntityToBeReturned(TimelineEntityDocument timelineEntityDocument, TimelineDataToRetrieve dataToRetrieve) {
        TimelineEntity entityToBeReturned = DocumentStoreUtils.createTimelineEntity(timelineEntityDocument.getType(), timelineEntityDocument.fetchTimelineEntity());
        entityToBeReturned.setIdentifier(new TimelineEntity.Identifier(timelineEntityDocument.getType(), timelineEntityDocument.getId()));
        entityToBeReturned.setCreatedTime(Long.valueOf(timelineEntityDocument.getCreatedTime()));
        entityToBeReturned.setInfo(timelineEntityDocument.getInfo());
        if (dataToRetrieve.getFieldsToRetrieve() != null) {
            DocumentStoreUtils.fillFields(entityToBeReturned, timelineEntityDocument, dataToRetrieve);
        }
        return entityToBeReturned;
    }

    public static TimelineEntity createEntityToBeReturned(TimelineEntityDocument timelineEntityDocument, TimelineFilterList confsToRetrieve, TimelineFilterList metricsToRetrieve) {
        TimelineEntity timelineEntity = timelineEntityDocument.fetchTimelineEntity();
        if (confsToRetrieve != null) {
            timelineEntity.setConfigs(DocumentStoreUtils.applyConfigFilter(confsToRetrieve, timelineEntity.getConfigs()));
        }
        if (metricsToRetrieve != null) {
            timelineEntity.setMetrics(DocumentStoreUtils.transformMetrics(metricsToRetrieve, timelineEntityDocument.getMetrics()));
        }
        return timelineEntity;
    }

    private static TimelineEntity createTimelineEntity(String type, TimelineEntity timelineEntity) {
        switch (TimelineEntityType.valueOf((String)type)) {
            case YARN_APPLICATION: {
                return new ApplicationEntity();
            }
            case YARN_FLOW_RUN: {
                return new FlowRunEntity();
            }
            case YARN_FLOW_ACTIVITY: {
                FlowActivityEntity flowActivityEntity = (FlowActivityEntity)timelineEntity;
                FlowActivityEntity newFlowActivity = new FlowActivityEntity();
                newFlowActivity.addFlowRuns((Collection)flowActivityEntity.getFlowRuns());
                return newFlowActivity;
            }
        }
        return new TimelineEntity();
    }

    private static void fillFields(TimelineEntity finalEntity, TimelineEntityDocument entityDoc, TimelineDataToRetrieve dataToRetrieve) {
        EnumSet<TimelineReader.Field> fieldsToRetrieve = dataToRetrieve.getFieldsToRetrieve();
        if (fieldsToRetrieve.contains(TimelineReader.Field.ALL)) {
            fieldsToRetrieve = EnumSet.allOf(TimelineReader.Field.class);
        }
        for (TimelineReader.Field field : fieldsToRetrieve) {
            switch (field) {
                case CONFIGS: {
                    finalEntity.setConfigs(DocumentStoreUtils.applyConfigFilter(dataToRetrieve.getConfsToRetrieve(), entityDoc.getConfigs()));
                    break;
                }
                case METRICS: {
                    finalEntity.setMetrics(DocumentStoreUtils.transformMetrics(dataToRetrieve.getMetricsToRetrieve(), entityDoc.getMetrics()));
                    break;
                }
                case INFO: {
                    finalEntity.setInfo(entityDoc.getInfo());
                    break;
                }
                case IS_RELATED_TO: {
                    finalEntity.setIsRelatedToEntities(entityDoc.getIsRelatedToEntities());
                    break;
                }
                case RELATES_TO: {
                    finalEntity.setIsRelatedToEntities(entityDoc.getIsRelatedToEntities());
                    break;
                }
                case EVENTS: {
                    finalEntity.setEvents(DocumentStoreUtils.transformEvents(entityDoc.getEvents().values()));
                    break;
                }
            }
        }
    }

    private static NavigableSet<TimelineEvent> transformEvents(Collection<Set<TimelineEventSubDoc>> eventSetColl) {
        TreeSet<TimelineEvent> timelineEvents = new TreeSet<TimelineEvent>();
        for (Set<TimelineEventSubDoc> eventSubDocs : eventSetColl) {
            for (TimelineEventSubDoc eventSubDoc : eventSubDocs) {
                timelineEvents.add(eventSubDoc.fetchTimelineEvent());
            }
        }
        return timelineEvents;
    }

    public static Set<TimelineMetric> transformMetrics(TimelineFilterList metricsToRetrieve, Map<String, Set<TimelineMetricSubDoc>> metrics) {
        if (metricsToRetrieve == null || DocumentStoreUtils.hasDataToBeRetrieve(metricsToRetrieve, metrics.keySet())) {
            HashSet<TimelineMetric> metricSet = new HashSet<TimelineMetric>();
            for (Set<TimelineMetricSubDoc> metricSubDocs : metrics.values()) {
                for (TimelineMetricSubDoc metricSubDoc : metricSubDocs) {
                    metricSet.add(metricSubDoc.fetchTimelineMetric());
                }
            }
            return metricSet;
        }
        return new HashSet<TimelineMetric>();
    }

    public static Map<String, String> applyConfigFilter(TimelineFilterList configsToRetrieve, Map<String, String> configs) {
        if (configsToRetrieve == null || DocumentStoreUtils.hasDataToBeRetrieve(configsToRetrieve, configs.keySet())) {
            return configs;
        }
        return new HashMap<String, String>();
    }

    private static boolean hasDataToBeRetrieve(TimelineFilterList timelineFilters, Set<String> dataSet) {
        HashSet<String> dataToBeRetrieved = new HashSet<String>();
        for (TimelineFilter timelineFilter : timelineFilters.getFilterList()) {
            TimelinePrefixFilter timelinePrefixFilter = (TimelinePrefixFilter)timelineFilter;
            dataToBeRetrieved.add(timelinePrefixFilter.getPrefix());
        }
        switch (timelineFilters.getOperator()) {
            case OR: {
                if (dataToBeRetrieved.size() == 0 || !Collections.disjoint(dataSet, dataToBeRetrieved)) {
                    return true;
                }
            }
            case AND: {
                if (dataToBeRetrieved.size() != 0 && !dataSet.containsAll(dataToBeRetrieved)) break;
                return true;
            }
        }
        return false;
    }
}

