/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.compression.lzma;

import java.io.IOException;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.TransformationResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.compression.lzma.LZMADecoder;
import org.apache.hadoop.shaded.org.glassfish.grizzly.compression.lzma.LZMAEncoder;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.BaseFilter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainContext;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.NextAction;

public class LZMAFilter
extends BaseFilter {
    private final LZMAEncoder encoder = new LZMAEncoder();
    private final LZMADecoder decoder = new LZMADecoder();

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer input;
        Connection connection = ctx.getConnection();
        TransformationResult result = this.decoder.transform(connection, input = (Buffer)ctx.getMessage());
        Buffer remainder = result.getExternalRemainder();
        if (remainder == null) {
            input.tryDispose();
        } else {
            input.shrink();
        }
        try {
            switch (result.getStatus()) {
                case COMPLETE: {
                    ctx.setMessage(result.getMessage());
                    this.decoder.finish(connection);
                    NextAction nextAction = ctx.getInvokeAction(remainder);
                    return nextAction;
                }
                case INCOMPLETE: {
                    NextAction nextAction = ctx.getStopAction(remainder);
                    return nextAction;
                }
                case ERROR: {
                    throw new IllegalStateException("LZMA decode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result.getStatus()));
        }
        finally {
            result.recycle();
        }
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        Buffer input = (Buffer)ctx.getMessage();
        TransformationResult result = this.encoder.transform(connection, input);
        if (!input.hasRemaining()) {
            input.tryDispose();
        } else {
            input.shrink();
        }
        try {
            switch (result.getStatus()) {
                case COMPLETE: {
                    this.encoder.finish(connection);
                }
                case INCOMPLETE: {
                    Buffer readyBuffer = (Buffer)result.getMessage();
                    if (readyBuffer != null) {
                        ctx.setMessage(readyBuffer);
                        NextAction nextAction = ctx.getInvokeAction();
                        return nextAction;
                    }
                    NextAction nextAction = ctx.getStopAction();
                    return nextAction;
                }
                case ERROR: {
                    throw new IllegalStateException("LZMA encode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result.getStatus()));
        }
        finally {
            result.recycle();
        }
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        this.decoder.release(connection);
        this.encoder.release(connection);
        return super.handleClose(ctx);
    }
}

