/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.jersey.server.impl.uri.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.uri.PathPattern;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.uri.rules.AtomicMatchingPatterns;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.uri.rules.PatternRulePair;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.uri.rules.automata.AutomataMatchingUriTemplateRules;
import org.apache.hadoop.shaded.com.sun.jersey.spi.uri.rules.UriRule;
import org.apache.hadoop.shaded.com.sun.jersey.spi.uri.rules.UriRules;

public final class UriRulesFactory {
    private UriRulesFactory() {
    }

    public static UriRules<UriRule> create(Map<PathPattern, UriRule> rulesMap) {
        return UriRulesFactory.create(rulesMap, null);
    }

    public static UriRules<UriRule> create(Map<PathPattern, UriRule> rulesMap, List<PatternRulePair<UriRule>> rules) {
        ArrayList<PatternRulePair<UriRule>> l = new ArrayList<PatternRulePair<UriRule>>();
        for (Map.Entry<PathPattern, UriRule> e : rulesMap.entrySet()) {
            l.add(new PatternRulePair<UriRule>(e.getKey(), e.getValue()));
        }
        if (rules != null) {
            l.addAll(rules);
        }
        return UriRulesFactory.create(l);
    }

    public static UriRules<UriRule> create(List<PatternRulePair<UriRule>> rules) {
        if (rules.size() < Integer.MAX_VALUE) {
            return new AtomicMatchingPatterns<UriRule>(rules);
        }
        return new AutomataMatchingUriTemplateRules<UriRule>(rules);
    }
}

