/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.storage.SchemaCreator;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.domain.DomainTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationTableRW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class HBaseTimelineSchemaCreator
implements SchemaCreator {
    static final String NAME = HBaseTimelineSchemaCreator.class.getSimpleName();
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTimelineSchemaCreator.class);
    private static final String SKIP_EXISTING_TABLE_OPTION_SHORT = "s";
    private static final String APP_METRICS_TTL_OPTION_SHORT = "ma";
    private static final String SUB_APP_METRICS_TTL_OPTION_SHORT = "msa";
    private static final String APP_TABLE_NAME_SHORT = "a";
    private static final String SUB_APP_TABLE_NAME_SHORT = "sa";
    private static final String APP_TO_FLOW_TABLE_NAME_SHORT = "a2f";
    private static final String ENTITY_METRICS_TTL_OPTION_SHORT = "me";
    private static final String ENTITY_TABLE_NAME_SHORT = "e";
    private static final String HELP_SHORT = "h";
    private static final String CREATE_TABLES_SHORT = "c";

    public void createTimelineSchema(String[] args) throws Exception {
        LOG.info("Starting the schema creation");
        Configuration hbaseConf = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf((Configuration)new YarnConfiguration());
        String[] otherArgs = new GenericOptionsParser(hbaseConf, args).getRemainingArgs();
        CommandLine commandLine = HBaseTimelineSchemaCreator.parseArgs(otherArgs);
        if (commandLine.hasOption(HELP_SHORT)) {
            HBaseTimelineSchemaCreator.printUsage();
        } else if (commandLine.hasOption(CREATE_TABLES_SHORT)) {
            String subApplicationTableMetricsTTL;
            String subApplicationTableName;
            String applicationTableMetricsTTL;
            String applicationTableName;
            String appToflowTableName;
            String entityTableMetricsTTL;
            String entityTableName = commandLine.getOptionValue(ENTITY_TABLE_NAME_SHORT);
            if (StringUtils.isNotBlank((CharSequence)entityTableName)) {
                hbaseConf.set("yarn.timeline-service.entity.table.name", entityTableName);
            }
            if (StringUtils.isNotBlank((CharSequence)(entityTableMetricsTTL = commandLine.getOptionValue(ENTITY_METRICS_TTL_OPTION_SHORT)))) {
                int entityMetricsTTL = Integer.parseInt(entityTableMetricsTTL);
                new EntityTableRW().setMetricsTTL(entityMetricsTTL, hbaseConf);
            }
            if (StringUtils.isNotBlank((CharSequence)(appToflowTableName = commandLine.getOptionValue(APP_TO_FLOW_TABLE_NAME_SHORT)))) {
                hbaseConf.set("yarn.timeline-service.app-flow.table.name", appToflowTableName);
            }
            if (StringUtils.isNotBlank((CharSequence)(applicationTableName = commandLine.getOptionValue(APP_TABLE_NAME_SHORT)))) {
                hbaseConf.set("yarn.timeline-service.application.table.name", applicationTableName);
            }
            if (StringUtils.isNotBlank((CharSequence)(applicationTableMetricsTTL = commandLine.getOptionValue(APP_METRICS_TTL_OPTION_SHORT)))) {
                int appMetricsTTL = Integer.parseInt(applicationTableMetricsTTL);
                new ApplicationTableRW().setMetricsTTL(appMetricsTTL, hbaseConf);
            }
            if (StringUtils.isNotBlank((CharSequence)(subApplicationTableName = commandLine.getOptionValue(SUB_APP_TABLE_NAME_SHORT)))) {
                hbaseConf.set("yarn.timeline-service.subapplication.table.name", subApplicationTableName);
            }
            if (StringUtils.isNotBlank((CharSequence)(subApplicationTableMetricsTTL = commandLine.getOptionValue(SUB_APP_METRICS_TTL_OPTION_SHORT)))) {
                int subAppMetricsTTL = Integer.parseInt(subApplicationTableMetricsTTL);
                new SubApplicationTableRW().setMetricsTTL(subAppMetricsTTL, hbaseConf);
            }
            boolean skipExisting = commandLine.hasOption(SKIP_EXISTING_TABLE_OPTION_SHORT);
            HBaseTimelineSchemaCreator.createAllSchemas(hbaseConf, skipExisting);
        } else {
            HBaseTimelineSchemaCreator.printUsage();
        }
    }

    private static CommandLine parseArgs(String[] args) throws ParseException {
        Options options = new Options();
        Option o = new Option(HELP_SHORT, "help", false, "print help information");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(CREATE_TABLES_SHORT, "create", false, "a mandatory option to create hbase tables");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(ENTITY_TABLE_NAME_SHORT, "entityTableName", true, "entity table name");
        o.setArgName("entityTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(ENTITY_METRICS_TTL_OPTION_SHORT, "entityMetricsTTL", true, "TTL for metrics column family");
        o.setArgName("entityMetricsTTL");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(APP_TO_FLOW_TABLE_NAME_SHORT, "appToflowTableName", true, "app to flow table name");
        o.setArgName("appToflowTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(APP_TABLE_NAME_SHORT, "applicationTableName", true, "application table name");
        o.setArgName("applicationTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(APP_METRICS_TTL_OPTION_SHORT, "applicationMetricsTTL", true, "TTL for metrics column family");
        o.setArgName("applicationMetricsTTL");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(SUB_APP_TABLE_NAME_SHORT, "subApplicationTableName", true, "subApplication table name");
        o.setArgName("subApplicationTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(SUB_APP_METRICS_TTL_OPTION_SHORT, "subApplicationMetricsTTL", true, "TTL for metrics column family");
        o.setArgName("subApplicationMetricsTTL");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(SKIP_EXISTING_TABLE_OPTION_SHORT, "skipExistingTable", false, "skip existing Hbase tables and continue to create new tables");
        o.setRequired(false);
        options.addOption(o);
        PosixParser parser = new PosixParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
        }
        catch (Exception e) {
            LOG.error("ERROR: " + e.getMessage() + "\n");
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(NAME + " ", options, true);
            System.exit(-1);
        }
        return commandLine;
    }

    private static void printUsage() {
        StringBuilder usage = new StringBuilder("Command Usage: \n");
        usage.append("TimelineSchemaCreator [-help] Display help info for all commands. Or\n").append("TimelineSchemaCreator -create [OPTIONAL_OPTIONS] Create hbase tables.\n\n").append("The Optional options for creating tables include: \n").append("[-entityTableName <Entity Table Name>] The name of the Entity table\n").append("[-entityMetricsTTL <Entity Table Metrics TTL>] TTL for metrics in the Entity table\n").append("[-appToflowTableName <AppToflow Table Name>] The name of the AppToFlow table\n").append("[-applicationTableName <Application Table Name>] The name of the Application table\n").append("[-applicationMetricsTTL <Application Table Metrics TTL>] TTL for metrics in the Application table\n").append("[-subApplicationTableName <SubApplication Table Name>] The name of the SubApplication table\n").append("[-subApplicationMetricsTTL  <SubApplication Table Metrics TTL>] TTL for metrics in the SubApplication table\n").append("[-skipExistingTable] Whether to skip existing hbase tables\n");
        System.out.println(usage.toString());
    }

    private static void createAllSchemas(Configuration hbaseConf, boolean skipExisting) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        try {
            if (skipExisting) {
                LOG.info("Will skip existing tables and continue on htable creation exceptions!");
            }
            HBaseTimelineSchemaCreator.createAllTables(hbaseConf, skipExisting);
            LOG.info("Successfully created HBase schema. ");
        }
        catch (IOException e) {
            LOG.error("Error in creating hbase tables: ", (Throwable)e);
            exceptions.add(e);
        }
        if (exceptions.size() > 0) {
            LOG.warn("Schema creation finished with the following exceptions");
            for (Exception exception : exceptions) {
                LOG.warn(exception.getMessage());
            }
            System.exit(-1);
        } else {
            LOG.info("Schema creation finished successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void createAllTables(Configuration hbaseConf, boolean skipExisting) throws IOException {
        block26: {
            try (Connection conn = null;){
                conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
                Admin admin = conn.getAdmin();
                if (admin == null) {
                    throw new IOException("Cannot create table since admin is null");
                }
                try {
                    new EntityTableRW().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new AppToFlowTableRW().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new ApplicationTableRW().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new FlowRunTableRW().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new FlowActivityTableRW().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new SubApplicationTableRW().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new DomainTableRW().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                        break block26;
                    }
                    throw e;
                }
            }
        }
    }
}

