/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.AbstractDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.EncodingState;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.encoding.RowIndexEncoderV1;
import org.apache.hadoop.hbase.io.encoding.RowIndexSeekerV1;
import org.apache.hadoop.hbase.util.ByteBufferUtils;

@InterfaceAudience.Private
public class RowIndexCodecV1
extends AbstractDataBlockEncoder {
    @Override
    public void startBlockEncoding(HFileBlockEncodingContext blkEncodingCtx, DataOutputStream out) throws IOException {
        if (blkEncodingCtx.getClass() != HFileBlockDefaultEncodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + " as the " + "encoding context.");
        }
        HFileBlockDefaultEncodingContext encodingCtx = (HFileBlockDefaultEncodingContext)blkEncodingCtx;
        encodingCtx.prepareEncoding(out);
        RowIndexEncoderV1 encoder = new RowIndexEncoderV1(out, encodingCtx);
        RowIndexEncodingState state = new RowIndexEncodingState();
        state.encoder = encoder;
        blkEncodingCtx.setEncodingState(state);
    }

    @Override
    public int encode(Cell cell, HFileBlockEncodingContext encodingCtx, DataOutputStream out) throws IOException {
        RowIndexEncodingState state = (RowIndexEncodingState)encodingCtx.getEncodingState();
        RowIndexEncoderV1 encoder = state.encoder;
        return encoder.write(cell);
    }

    @Override
    public void endBlockEncoding(HFileBlockEncodingContext encodingCtx, DataOutputStream out, byte[] uncompressedBytesWithHeader) throws IOException {
        RowIndexEncodingState state = (RowIndexEncodingState)encodingCtx.getEncodingState();
        RowIndexEncoderV1 encoder = state.encoder;
        encoder.flush();
        this.postEncoding(encodingCtx);
    }

    @Override
    public ByteBuffer decodeKeyValues(DataInputStream source, HFileBlockDecodingContext decodingCtx) throws IOException {
        if (!decodingCtx.getHFileContext().isIncludesTags()) {
            ByteBuffer sourceAsBuffer = ByteBufferUtils.drainInputStreamToBuffer(source);
            sourceAsBuffer.mark();
            sourceAsBuffer.position(sourceAsBuffer.limit() - 4);
            int onDiskSize = sourceAsBuffer.getInt();
            sourceAsBuffer.reset();
            ByteBuffer dup = sourceAsBuffer.duplicate();
            dup.position(sourceAsBuffer.position());
            dup.limit(sourceAsBuffer.position() + onDiskSize);
            return dup.slice();
        }
        ByteBuffer sourceAsBuffer = ByteBufferUtils.drainInputStreamToBuffer(source);
        sourceAsBuffer.mark();
        RowIndexSeekerV1 seeker = new RowIndexSeekerV1(KeyValue.COMPARATOR, decodingCtx);
        seeker.setCurrentBuffer(sourceAsBuffer);
        ArrayList<ByteBuffer> kvs = new ArrayList<ByteBuffer>();
        kvs.add(seeker.getKeyValueBuffer());
        while (seeker.next()) {
            kvs.add(seeker.getKeyValueBuffer());
        }
        int totalLength = 0;
        for (ByteBuffer buf : kvs) {
            totalLength += buf.remaining();
        }
        byte[] keyValueBytes = new byte[totalLength];
        ByteBuffer result = ByteBuffer.wrap(keyValueBytes);
        for (ByteBuffer buf : kvs) {
            result.put(buf);
        }
        return result;
    }

    @Override
    public ByteBuffer getFirstKeyInBlock(ByteBuffer block) {
        block.mark();
        int keyLength = block.getInt();
        block.getInt();
        int pos = block.position();
        block.reset();
        ByteBuffer dup = block.duplicate();
        dup.position(pos);
        dup.limit(pos + keyLength);
        return dup.slice();
    }

    @Override
    public DataBlockEncoder.EncodedSeeker createSeeker(KeyValue.KVComparator comparator, HFileBlockDecodingContext decodingCtx) {
        return new RowIndexSeekerV1(comparator, decodingCtx);
    }

    private static class RowIndexEncodingState
    extends EncodingState {
        RowIndexEncoderV1 encoder = null;

        private RowIndexEncodingState() {
        }
    }
}

