/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.jboss.netty.channel.Channel;

class WriteCtx {
    public static final Log LOG = LogFactory.getLog(WriteCtx.class);
    private final FileHandle handle;
    private long offset;
    private int count;
    private int originalCount;
    public static final int INVALID_ORIGINAL_COUNT = -1;
    private int trimDelta;
    private final Nfs3Constant.WriteStableHow stableHow;
    private volatile ByteBuffer data;
    private final Channel channel;
    private final int xid;
    private boolean replied;
    private RandomAccessFile raf;
    private long dumpFileOffset;
    private volatile DataState dataState;
    public final long startTime;

    public synchronized int getOriginalCount() {
        return this.originalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimWrite(int delta) {
        Preconditions.checkState((delta < this.count ? 1 : 0) != 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trim write request by delta:" + delta + " " + this.toString()));
        }
        WriteCtx writeCtx = this;
        synchronized (writeCtx) {
            this.trimDelta = delta;
            if (this.originalCount == -1) {
                this.originalCount = this.count;
            }
            this.trimData();
        }
    }

    public DataState getDataState() {
        return this.dataState;
    }

    public void setDataState(DataState dataState) {
        this.dataState = dataState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long dumpData(FileOutputStream dumpOut, RandomAccessFile raf) throws IOException {
        if (this.dataState != DataState.ALLOW_DUMP) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("No need to dump with status(replied,dataState):(" + this.replied + "," + (Object)((Object)this.dataState) + ")"));
            }
            return 0L;
        }
        Preconditions.checkState((this.getOriginalCount() == -1 ? 1 : 0) != 0);
        this.raf = raf;
        this.dumpFileOffset = dumpOut.getChannel().position();
        dumpOut.write(this.data.array(), 0, this.count);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("After dump, new dumpFileOffset:" + this.dumpFileOffset));
        }
        if (this.dataState == DataState.ALLOW_DUMP) {
            WriteCtx writeCtx = this;
            synchronized (writeCtx) {
                if (this.dataState == DataState.ALLOW_DUMP) {
                    this.data = null;
                    this.dataState = DataState.DUMPED;
                    return this.count;
                }
            }
        }
        return 0L;
    }

    FileHandle getHandle() {
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getOffset() {
        WriteCtx writeCtx = this;
        synchronized (writeCtx) {
            return this.offset + (long)this.trimDelta;
        }
    }

    private synchronized long getPlainOffset() {
        return this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCount() {
        WriteCtx writeCtx = this;
        synchronized (writeCtx) {
            return this.count - this.trimDelta;
        }
    }

    Nfs3Constant.WriteStableHow getStableHow() {
        return this.stableHow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ByteBuffer getData() throws IOException {
        if (this.dataState != DataState.DUMPED) {
            WriteCtx writeCtx = this;
            synchronized (writeCtx) {
                if (this.dataState != DataState.DUMPED) {
                    Preconditions.checkState((this.data != null ? 1 : 0) != 0);
                    return this.data;
                }
            }
        }
        this.loadData();
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() throws IOException {
        Preconditions.checkState((this.data == null ? 1 : 0) != 0);
        byte[] rawData = new byte[this.count];
        this.raf.seek(this.dumpFileOffset);
        int size = this.raf.read(rawData, 0, this.count);
        if (size != this.count) {
            throw new IOException("Data count is " + this.count + ", but read back " + size + "bytes");
        }
        WriteCtx writeCtx = this;
        synchronized (writeCtx) {
            this.data = ByteBuffer.wrap(rawData);
            this.trimData();
        }
    }

    private void trimData() {
        if (this.data != null && this.trimDelta > 0) {
            this.dataState = DataState.NO_DUMP;
            this.data.position(this.data.position() + this.trimDelta);
            this.offset += (long)this.trimDelta;
            this.count -= this.trimDelta;
            this.trimDelta = 0;
        }
    }

    public void writeData(HdfsDataOutputStream fos) throws IOException {
        ByteBuffer dataBuffer;
        Preconditions.checkState((fos != null ? 1 : 0) != 0);
        try {
            dataBuffer = this.getData();
        }
        catch (Exception e1) {
            LOG.error((Object)("Failed to get request data offset:" + this.getPlainOffset() + " " + "count:" + this.count + " error:" + e1));
            throw new IOException("Can't get WriteCtx.data");
        }
        byte[] data = dataBuffer.array();
        int position = dataBuffer.position();
        int limit = dataBuffer.limit();
        Preconditions.checkState((limit - position == this.count ? 1 : 0) != 0);
        if (position != 0 && limit != this.getOriginalCount()) {
            throw new IOException("Modified write has differnt original size.buff position:" + position + " buff limit:" + limit + ". " + this.toString());
        }
        fos.write(data, position, this.count);
    }

    Channel getChannel() {
        return this.channel;
    }

    int getXid() {
        return this.xid;
    }

    boolean getReplied() {
        return this.replied;
    }

    void setReplied(boolean replied) {
        this.replied = replied;
    }

    WriteCtx(FileHandle handle, long offset, int count, int originalCount, Nfs3Constant.WriteStableHow stableHow, ByteBuffer data, Channel channel, int xid, boolean replied, DataState dataState) {
        this.handle = handle;
        this.offset = offset;
        this.count = count;
        this.originalCount = originalCount;
        this.trimDelta = 0;
        this.stableHow = stableHow;
        this.data = data;
        this.channel = channel;
        this.xid = xid;
        this.replied = replied;
        this.dataState = dataState;
        this.raf = null;
        this.startTime = System.nanoTime();
    }

    public String toString() {
        return "Id:" + this.handle.getFileId() + " offset:" + this.getPlainOffset() + " " + "count:" + this.count + " originalCount:" + this.getOriginalCount() + " stableHow:" + this.stableHow + " replied:" + this.replied + " dataState:" + (Object)((Object)this.dataState) + " xid:" + this.xid;
    }

    public static enum DataState {
        ALLOW_DUMP,
        NO_DUMP,
        DUMPED;

    }
}

