/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store.oauth2;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.azure.datalake.store.QueryParams;
import com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureADAuthenticator {
    private static final Logger log = LoggerFactory.getLogger((String)AzureADAuthenticator.class.getName());
    static final String resource = "https://datalake.azure.net/";

    public static AzureADToken getTokenUsingClientCreds(String authEndpoint, String clientId, String clientSecret) throws IOException {
        QueryParams qp = new QueryParams();
        qp.add("resource", resource);
        qp.add("grant_type", "client_credentials");
        qp.add("client_id", clientId);
        qp.add("client_secret", clientSecret);
        log.debug("AADToken: starting to fetch token using client creds for client ID " + clientId);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize());
    }

    public static AzureADToken getTokenFromMsi(int localPort, String tenantGuid) throws IOException {
        if (localPort <= 0) {
            localPort = 50342;
        }
        String authEndpoint = "http://localhost:" + localPort + "/oauth2/token";
        QueryParams qp = new QueryParams();
        qp.add("resource", resource);
        if (tenantGuid != null && tenantGuid.length() > 0) {
            String authority = "https://login.microsoftonline.com/" + tenantGuid;
            qp.add("authority", authority);
        }
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Metadata", "true");
        log.debug("AADToken: starting to fetch token using MSI");
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize(), headers);
    }

    public static AzureADToken getTokenUsingRefreshToken(String clientId, String refreshToken) throws IOException {
        String authEndpoint = "https://login.microsoftonline.com/Common/oauth2/token";
        QueryParams qp = new QueryParams();
        qp.add("grant_type", "refresh_token");
        qp.add("refresh_token", refreshToken);
        if (clientId != null) {
            qp.add("client_id", clientId);
        }
        log.debug("AADToken: starting to fetch token using refresh token for client ID " + clientId);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize());
    }

    public static AzureADToken getTokenUsingUserCreds(String clientId, String username, String password) throws IOException {
        String authEndpoint = "https://login.microsoftonline.com/Common/oauth2/token";
        QueryParams qp = new QueryParams();
        qp.add("grant_type", "password");
        qp.add("resource", resource);
        qp.add("scope", "openid");
        qp.add("client_id", clientId);
        qp.add("username", username);
        qp.add("password", password);
        log.debug("AADToken: starting to fetch token using username for user " + username);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize());
    }

    private static AzureADToken getTokenCall(String authEndpoint, String body, Hashtable<String, String> headers) throws IOException {
        URL url = new URL(authEndpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        if (headers != null && headers.size() > 0) {
            for (String name : headers.keySet()) {
                conn.setRequestProperty(name, headers.get(name));
            }
        }
        conn.setDoOutput(true);
        conn.getOutputStream().write(body.getBytes("UTF-8"));
        int httpResponseCode = conn.getResponseCode();
        if (httpResponseCode != 200) {
            log.debug("AADToken: HTTP connection failed for getting token from AzureAD. Http response: " + httpResponseCode + " " + conn.getResponseMessage());
            throw new IOException("Failed to acquire token from AzureAD. Http response: " + httpResponseCode + " " + conn.getResponseMessage());
        }
        InputStream httpResponseStream = conn.getInputStream();
        AzureADToken token = AzureADAuthenticator.parseTokenFromStream(httpResponseStream);
        return token;
    }

    private static AzureADToken getTokenCall(String authEndpoint, String body) throws IOException {
        return AzureADAuthenticator.getTokenCall(authEndpoint, body, null);
    }

    private static AzureADToken parseTokenFromStream(InputStream httpResponseStream) throws IOException {
        AzureADToken token = new AzureADToken();
        try {
            int expiryPeriod = 0;
            JsonFactory jf = new JsonFactory();
            JsonParser jp = jf.createParser(httpResponseStream);
            jp.nextToken();
            while (jp.hasCurrentToken()) {
                if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = jp.getCurrentName();
                    jp.nextToken();
                    String fieldValue = jp.getText();
                    if (fieldName.equals("access_token")) {
                        token.accessToken = fieldValue;
                    }
                    if (fieldName.equals("expires_in")) {
                        expiryPeriod = Integer.parseInt(fieldValue);
                    }
                }
                jp.nextToken();
            }
            jp.close();
            long expiry = System.currentTimeMillis();
            token.expiry = new Date(expiry += (long)expiryPeriod * 1000L);
            log.debug("AADToken: fetched token with expiry " + token.expiry.toString());
        }
        catch (Exception ex) {
            log.debug("AADToken: got exception when parsing json token " + ex.toString());
            throw ex;
        }
        finally {
            httpResponseStream.close();
        }
        return token;
    }
}

