/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONUnmarshaller;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

class FederationBlock
extends HtmlBlock {
    private static final long BYTES_IN_MB = 0x100000L;
    private final Router router;

    @Inject
    FederationBlock(View.ViewContext ctx, Router router) {
        super(ctx);
        this.router = router;
    }

    public void render(HtmlBlock.Block html) {
        Configuration conf = this.router.getConfig();
        boolean isEnabled = conf.getBoolean("yarn.federation.enabled", false);
        if (isEnabled) {
            this.setTitle("Federation");
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#rms").thead().tr().th(".id", "SubCluster").th(".submittedA", "Applications Submitted*").th(".pendingA", "Applications Pending*").th(".runningA", "Applications Running*").th(".failedA", "Applications Failed*").th(".killedA", "Applications Killed*").th(".completedA", "Applications Completed*").th(".contAllocated", "Containers Allocated").th(".contReserved", "Containers Reserved").th(".contPending", "Containers Pending").th(".availableM", "Available Memory").th(".allocatedM", "Allocated Memory").th(".reservedM", "Reserved Memory").th(".totalM", "Total Memory").th(".availableVC", "Available VirtualCores").th(".allocatedVC", "Allocated VirtualCores").th(".reservedVC", "Reserved VirtualCores").th(".totalVC", "Total VirtualCores").th(".activeN", "Active Nodes").th(".lostN", "Lost Nodes").th(".availableN", "Available Nodes").th(".unhealtyN", "Unhealthy Nodes").th(".rebootedN", "Rebooted Nodes").th(".totalN", "Total Nodes")._())._()).tbody();
            try {
                FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance();
                Map subClustersInfo = facade.getSubClusters(true);
                ArrayList subclusters = new ArrayList();
                subclusters.addAll(subClustersInfo.values());
                Comparator<SubClusterInfo> cmp = new Comparator<SubClusterInfo>(){

                    @Override
                    public int compare(SubClusterInfo o1, SubClusterInfo o2) {
                        return o1.getSubClusterId().compareTo(o2.getSubClusterId());
                    }
                };
                Collections.sort(subclusters, cmp);
                for (SubClusterInfo subcluster : subclusters) {
                    SubClusterId subClusterId = subcluster.getSubClusterId();
                    String webAppAddress = subcluster.getRMWebServiceAddress();
                    String capability = subcluster.getCapability();
                    ClusterMetricsInfo subClusterInfo = FederationBlock.getClusterMetricsInfo(capability);
                    ((Hamlet.TR)tbody.tr().td().a("//" + webAppAddress, subClusterId.toString())._()).td(Integer.toString(subClusterInfo.getAppsSubmitted())).td(Integer.toString(subClusterInfo.getAppsPending())).td(Integer.toString(subClusterInfo.getAppsRunning())).td(Integer.toString(subClusterInfo.getAppsFailed())).td(Integer.toString(subClusterInfo.getAppsKilled())).td(Integer.toString(subClusterInfo.getAppsCompleted())).td(Integer.toString(subClusterInfo.getContainersAllocated())).td(Integer.toString(subClusterInfo.getReservedContainers())).td(Integer.toString(subClusterInfo.getPendingContainers())).td(StringUtils.byteDesc((long)(subClusterInfo.getAvailableMB() * 0x100000L))).td(StringUtils.byteDesc((long)(subClusterInfo.getAllocatedMB() * 0x100000L))).td(StringUtils.byteDesc((long)(subClusterInfo.getReservedMB() * 0x100000L))).td(StringUtils.byteDesc((long)(subClusterInfo.getTotalMB() * 0x100000L))).td(Long.toString(subClusterInfo.getAvailableVirtualCores())).td(Long.toString(subClusterInfo.getAllocatedVirtualCores())).td(Long.toString(subClusterInfo.getReservedVirtualCores())).td(Long.toString(subClusterInfo.getTotalVirtualCores())).td(Integer.toString(subClusterInfo.getActiveNodes())).td(Integer.toString(subClusterInfo.getLostNodes())).td(Integer.toString(subClusterInfo.getDecommissionedNodes())).td(Integer.toString(subClusterInfo.getUnhealthyNodes())).td(Integer.toString(subClusterInfo.getRebootedNodes())).td(Integer.toString(subClusterInfo.getTotalNodes()))._();
                }
            }
            catch (YarnException e) {
                LOG.error("Cannot render ResourceManager", (Throwable)e);
            }
            ((Hamlet.DIV)((Hamlet)((Hamlet.TABLE)tbody._())._()).div().p()._(new Object[]{"*The application counts are local per subcluster"})._())._();
        } else {
            this.setTitle("Federation is not Enabled!");
        }
    }

    private static ClusterMetricsInfo getClusterMetricsInfo(String capability) {
        ClusterMetricsInfo clusterMetrics = null;
        try {
            JSONJAXBContext jc = new JSONJAXBContext(JSONConfiguration.mapped().rootUnwrapping(false).build(), new Class[]{ClusterMetricsInfo.class});
            JSONUnmarshaller unmarshaller = jc.createJSONUnmarshaller();
            clusterMetrics = (ClusterMetricsInfo)unmarshaller.unmarshalFromJSON((Reader)new StringReader(capability), ClusterMetricsInfo.class);
        }
        catch (Exception e) {
            LOG.error("Cannot parse SubCluster info", (Throwable)e);
        }
        return clusterMetrics;
    }
}

