/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.azurebfs.services.AbfsClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.StaticRetryPolicy;

public class AbfsClientContextBuilder {
    private ExponentialRetryPolicy exponentialRetryPolicy;
    private StaticRetryPolicy staticRetryPolicy;
    private AbfsPerfTracker abfsPerfTracker;
    private AbfsCounters abfsCounters;

    public AbfsClientContextBuilder withExponentialRetryPolicy(ExponentialRetryPolicy exponentialRetryPolicy) {
        this.exponentialRetryPolicy = exponentialRetryPolicy;
        return this;
    }

    public AbfsClientContextBuilder withStaticRetryPolicy(StaticRetryPolicy staticRetryPolicy) {
        this.staticRetryPolicy = staticRetryPolicy;
        return this;
    }

    public AbfsClientContextBuilder withAbfsPerfTracker(AbfsPerfTracker abfsPerfTracker) {
        this.abfsPerfTracker = abfsPerfTracker;
        return this;
    }

    public AbfsClientContextBuilder withAbfsCounters(AbfsCounters abfsCounters) {
        this.abfsCounters = abfsCounters;
        return this;
    }

    public AbfsClientContext build() {
        return new AbfsClientContext(this.exponentialRetryPolicy, this.staticRetryPolicy, this.abfsPerfTracker, this.abfsCounters);
    }
}

