/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestDataTransferThrottler {
    @Test
    public void testReadDataTransferThrottler() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path file = new Path("/test");
            long fileLength = 0x5000000L;
            DFSTestUtil.createFile((FileSystem)fs, file, fileLength, (short)1, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, file, (short)1);
            DataNode dataNode = cluster.getDataNodes().get(0);
            Assert.assertNull((Object)dataNode.xserver.getReadThrottler());
            Assert.assertEquals((long)fileLength, (long)DFSTestUtil.readFileAsBytes((FileSystem)fs, file).length);
            long bandwidthPerSec = 0x800000L;
            conf.setLong("dfs.datanode.data.read.bandwidthPerSec", bandwidthPerSec);
            cluster.stopDataNode(0);
            cluster.startDataNodes((Configuration)conf, 1, true, null, null);
            dataNode = cluster.getDataNodes().get(0);
            Assert.assertEquals((long)bandwidthPerSec, (long)dataNode.xserver.getReadThrottler().getBandwidth());
            long start = Time.monotonicNow();
            Assert.assertEquals((long)fileLength, (long)DFSTestUtil.readFileAsBytes((FileSystem)fs, file).length);
            long elapsedTime = Time.monotonicNow() - start;
            long expectedElapsedTime = fileLength / bandwidthPerSec * 1000L;
            long acceptableError = 1000L;
            Assert.assertTrue((elapsedTime >= expectedElapsedTime - acceptableError ? 1 : 0) != 0);
        }
    }
}

