/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.terracotta.management.model.call;

import java.io.Serializable;
import java.util.Objects;

public final class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object value;
    private final String className;

    public Parameter(Object value) {
        this.value = Objects.requireNonNull(value);
        this.className = value.getClass().getName();
    }

    public Parameter(Object value, String className) {
        this.value = value;
        this.className = Objects.requireNonNull(className);
    }

    public Object getValue() {
        return this.value;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.value != null ? !this.value.equals(parameter.value) : parameter.value != null) {
            return false;
        }
        return this.className.equals(parameter.className);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.className.hashCode();
        return result;
    }
}

