/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.And;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.LocalizedMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.Not;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.Or;
import org.apache.hadoop.shaded.org.mockito.internal.progress.ArgumentMatcherStorage;

public class ArgumentMatcherStorageImpl
implements ArgumentMatcherStorage {
    private static final int TWO_SUB_MATCHERS = 2;
    private static final int ONE_SUB_MATCHER = 1;
    private final Stack<LocalizedMatcher> matcherStack = new Stack();

    @Override
    public void reportMatcher(ArgumentMatcher<?> matcher) {
        this.matcherStack.push(new LocalizedMatcher(matcher));
    }

    @Override
    public List<LocalizedMatcher> pullLocalizedMatchers() {
        if (this.matcherStack.isEmpty()) {
            return Collections.emptyList();
        }
        List<LocalizedMatcher> lastMatchers = this.resetStack();
        return lastMatchers;
    }

    @Override
    public void reportAnd() {
        this.assertStateFor("And(?)", 2);
        ArgumentMatcher<?> m1 = this.popMatcher();
        ArgumentMatcher<?> m2 = this.popMatcher();
        this.reportMatcher(new And(m1, m2));
    }

    @Override
    public void reportOr() {
        this.assertStateFor("Or(?)", 2);
        ArgumentMatcher<?> m1 = this.popMatcher();
        ArgumentMatcher<?> m2 = this.popMatcher();
        this.reportMatcher(new Or(m1, m2));
    }

    @Override
    public void reportNot() {
        this.assertStateFor("Not(?)", 1);
        ArgumentMatcher<?> m = this.popMatcher();
        this.reportMatcher(new Not(m));
    }

    @Override
    public void validateState() {
        if (!this.matcherStack.isEmpty()) {
            List<LocalizedMatcher> lastMatchers = this.resetStack();
            throw Reporter.misplacedArgumentMatcher(lastMatchers);
        }
    }

    @Override
    public void reset() {
        this.matcherStack.clear();
    }

    private void assertStateFor(String additionalMatcherName, int subMatchersCount) {
        if (this.matcherStack.isEmpty()) {
            throw Reporter.reportNoSubMatchersFound(additionalMatcherName);
        }
        if (this.matcherStack.size() < subMatchersCount) {
            List<LocalizedMatcher> lastMatchers = this.resetStack();
            throw Reporter.incorrectUseOfAdditionalMatchers(additionalMatcherName, subMatchersCount, lastMatchers);
        }
    }

    private ArgumentMatcher<?> popMatcher() {
        return this.matcherStack.pop().getMatcher();
    }

    private List<LocalizedMatcher> resetStack() {
        ArrayList<LocalizedMatcher> lastMatchers = new ArrayList<LocalizedMatcher>(this.matcherStack);
        this.reset();
        return lastMatchers;
    }
}

