/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.List;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsVisitor;
import org.apache.hadoop.metrics2.impl.MetricsLists;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMetricsVisitor {
    @Captor
    private ArgumentCaptor<MetricsInfo> c1;
    @Captor
    private ArgumentCaptor<MetricsInfo> c2;
    @Captor
    private ArgumentCaptor<MetricsInfo> g1;
    @Captor
    private ArgumentCaptor<MetricsInfo> g2;
    @Captor
    private ArgumentCaptor<MetricsInfo> g3;
    @Captor
    private ArgumentCaptor<MetricsInfo> g4;

    @Test
    public void testCommon() {
        MetricsVisitor visitor = (MetricsVisitor)Mockito.mock(MetricsVisitor.class);
        MetricsRegistry registry = new MetricsRegistry("test");
        List metrics = MetricsLists.builder("test").addCounter(Interns.info((String)"c1", (String)"int counter"), 1).addCounter(Interns.info((String)"c2", (String)"long counter"), 2L).addGauge(Interns.info((String)"g1", (String)"int gauge"), 5).addGauge(Interns.info((String)"g2", (String)"long gauge"), 6L).addGauge(Interns.info((String)"g3", (String)"float gauge"), 7.0f).addGauge(Interns.info((String)"g4", (String)"double gauge"), 8.0).metrics();
        for (AbstractMetric metric : metrics) {
            metric.visit(visitor);
        }
        ((MetricsVisitor)Mockito.verify((Object)visitor)).counter((MetricsInfo)this.c1.capture(), Mockito.eq((int)1));
        Assert.assertEquals((String)"c1 name", (Object)"c1", (Object)((MetricsInfo)this.c1.getValue()).name());
        Assert.assertEquals((String)"c1 description", (Object)"int counter", (Object)((MetricsInfo)this.c1.getValue()).description());
        ((MetricsVisitor)Mockito.verify((Object)visitor)).counter((MetricsInfo)this.c2.capture(), Mockito.eq((long)2L));
        Assert.assertEquals((String)"c2 name", (Object)"c2", (Object)((MetricsInfo)this.c2.getValue()).name());
        Assert.assertEquals((String)"c2 description", (Object)"long counter", (Object)((MetricsInfo)this.c2.getValue()).description());
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricsInfo)this.g1.capture(), Mockito.eq((int)5));
        Assert.assertEquals((String)"g1 name", (Object)"g1", (Object)((MetricsInfo)this.g1.getValue()).name());
        Assert.assertEquals((String)"g1 description", (Object)"int gauge", (Object)((MetricsInfo)this.g1.getValue()).description());
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricsInfo)this.g2.capture(), Mockito.eq((long)6L));
        Assert.assertEquals((String)"g2 name", (Object)"g2", (Object)((MetricsInfo)this.g2.getValue()).name());
        Assert.assertEquals((String)"g2 description", (Object)"long gauge", (Object)((MetricsInfo)this.g2.getValue()).description());
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricsInfo)this.g3.capture(), Mockito.eq((float)7.0f));
        Assert.assertEquals((String)"g3 name", (Object)"g3", (Object)((MetricsInfo)this.g3.getValue()).name());
        Assert.assertEquals((String)"g3 description", (Object)"float gauge", (Object)((MetricsInfo)this.g3.getValue()).description());
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricsInfo)this.g4.capture(), Mockito.eq((double)8.0));
        Assert.assertEquals((String)"g4 name", (Object)"g4", (Object)((MetricsInfo)this.g4.getValue()).name());
        Assert.assertEquals((String)"g4 description", (Object)"double gauge", (Object)((MetricsInfo)this.g4.getValue()).description());
    }
}

