/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.service.component.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentHealthThresholdMonitor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentHealthThresholdMonitor.class);
    private final Component component;
    private final int healthThresholdPercent;
    private final long healthThresholdWindowSecs;
    private final long healthThresholdWindowNanos;
    private long firstOccurrenceTimestamp = 0L;
    private float prevReadyContainerFraction = 0.0f;

    public ComponentHealthThresholdMonitor(Component component, int healthThresholdPercent, long healthThresholdWindowSecs) {
        this.component = component;
        this.healthThresholdPercent = healthThresholdPercent;
        this.healthThresholdWindowSecs = healthThresholdWindowSecs;
        this.healthThresholdWindowNanos = TimeUnit.NANOSECONDS.convert(healthThresholdWindowSecs, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        LOG.debug("ComponentHealthThresholdMonitor run method");
        long desiredContainerCount = this.component.getNumDesiredInstances();
        if (desiredContainerCount == 0L) {
            return;
        }
        long readyContainerCount = this.component.getNumReadyInstances();
        float thresholdFraction = (float)this.healthThresholdPercent / 100.0f;
        float readyContainerFraction = (float)readyContainerCount / (float)desiredContainerCount;
        boolean healthChanged = false;
        if ((double)Math.abs(readyContainerFraction - this.prevReadyContainerFraction) > 1.0E-7) {
            this.prevReadyContainerFraction = readyContainerFraction;
            healthChanged = true;
        }
        String readyContainerPercentStr = String.format("%.2f", Float.valueOf(readyContainerFraction * 100.0f));
        if (readyContainerFraction < thresholdFraction) {
            long currentTimestamp = System.nanoTime();
            if (this.firstOccurrenceTimestamp == 0L) {
                this.firstOccurrenceTimestamp = currentTimestamp;
                Date date = new Date();
                LOG.info("[COMPONENT {}] Health has gone below threshold. Starting health threshold timer at ts = {} ({})", new Object[]{this.component.getName(), date.getTime(), date});
            }
            long elapsedTime = currentTimestamp - this.firstOccurrenceTimestamp;
            long elapsedTimeSecs = TimeUnit.SECONDS.convert(elapsedTime, TimeUnit.NANOSECONDS);
            LOG.warn("[COMPONENT {}] Current health {}% is below health threshold of {}% for {} secs (threshold window = {} secs)", new Object[]{this.component.getName(), readyContainerPercentStr, this.healthThresholdPercent, elapsedTimeSecs, this.healthThresholdWindowSecs});
            if (elapsedTime > this.healthThresholdWindowNanos) {
                LOG.warn("[COMPONENT {}] Current health {}% has been below health threshold of {}% for {} secs (threshold window = {} secs)", new Object[]{this.component.getName(), readyContainerPercentStr, this.healthThresholdPercent, elapsedTimeSecs, this.healthThresholdWindowSecs});
                String exitDiag = String.format("Service is being killed because container health for component %s was %s%% (health threshold = %d%%) for %d secs (threshold window = %d secs)", this.component.getName(), readyContainerPercentStr, this.healthThresholdPercent, elapsedTimeSecs, this.healthThresholdWindowSecs);
                this.component.getScheduler().getDiagnostics().append((CharSequence)exitDiag);
                LOG.warn(exitDiag);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted on sleep while exiting.", (Throwable)e);
                }
                ExitUtil.terminate((int)-1);
            }
        } else {
            String logMsg = "[COMPONENT {}] Health threshold = {}%, Current health = {}% (Current Ready count = {}, Desired count = {})";
            if (healthChanged) {
                LOG.info(logMsg, new Object[]{this.component.getName(), this.healthThresholdPercent, readyContainerPercentStr, readyContainerCount, desiredContainerCount});
            } else {
                LOG.debug(logMsg, new Object[]{this.component.getName(), this.healthThresholdPercent, readyContainerPercentStr, readyContainerCount, desiredContainerCount});
            }
            if (this.firstOccurrenceTimestamp != 0L) {
                Date date = new Date();
                LOG.info("[COMPONENT {}] Health recovered above threshold at ts = {} ({})", new Object[]{this.component.getName(), date.getTime(), date});
                this.firstOccurrenceTimestamp = 0L;
            }
        }
    }
}

