/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.constants;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class AbfsHttpConstants {
    public static final String FILESYSTEM = "filesystem";
    public static final String FILE = "file";
    public static final String DIRECTORY = "directory";
    public static final String APPEND_ACTION = "append";
    public static final String FLUSH_ACTION = "flush";
    public static final String SET_PROPERTIES_ACTION = "setProperties";
    public static final String SET_ACCESS_CONTROL = "setAccessControl";
    public static final String GET_ACCESS_CONTROL = "getAccessControl";
    public static final String CHECK_ACCESS = "checkAccess";
    public static final String GET_STATUS = "getStatus";
    public static final String ACQUIRE_LEASE_ACTION = "acquire";
    public static final String BREAK_LEASE_ACTION = "break";
    public static final String RELEASE_LEASE_ACTION = "release";
    public static final String RENEW_LEASE_ACTION = "renew";
    public static final String DEFAULT_LEASE_BREAK_PERIOD = "0";
    public static final String DEFAULT_TIMEOUT = "90";
    public static final String APPEND_BLOB_TYPE = "appendblob";
    public static final String TOKEN_VERSION = "2";
    public static final String JAVA_VENDOR = "java.vendor";
    public static final String JAVA_VERSION = "java.version";
    public static final String OS_NAME = "os.name";
    public static final String OS_VERSION = "os.version";
    public static final String OS_ARCH = "os.arch";
    public static final String APN_VERSION = "APN/1.0";
    public static final String CLIENT_VERSION = "Azure Blob FS/" + VersionInfo.getVersion();
    public static final String HTTP_METHOD_DELETE = "DELETE";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_HEAD = "HEAD";
    public static final String HTTP_METHOD_PATCH = "PATCH";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_PUT = "PUT";
    public static final int HTTP_CONTINUE = 100;
    public static final String EXPECT_100_JDK_ERROR = "Server rejected operation";
    public static final String SINGLE_WHITE_SPACE = " ";
    public static final String EMPTY_STRING = "";
    public static final String FORWARD_SLASH = "/";
    public static final String DOT = ".";
    public static final String PLUS = "+";
    public static final String STAR = "*";
    public static final String COMMA = ",";
    public static final String COLON = ":";
    public static final String EQUAL = "=";
    public static final String QUESTION_MARK = "?";
    public static final String AND_MARK = "&";
    public static final String SEMICOLON = ";";
    public static final String AT = "@";
    public static final String HTTP_HEADER_PREFIX = "x-ms-";
    public static final String HASH = "#";
    public static final String TRUE = "true";
    public static final String PLUS_ENCODE = "%20";
    public static final String FORWARD_SLASH_ENCODE = "%2F";
    public static final String AZURE_DISTRIBUTED_FILE_SYSTEM_AUTHORITY_DELIMITER = "@";
    public static final String UTF_8 = "utf-8";
    public static final String GMT_TIMEZONE = "GMT";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String ROOT_PATH = "/";
    public static final String ACCESS_MASK = "mask:";
    public static final String ACCESS_USER = "user:";
    public static final String ACCESS_GROUP = "group:";
    public static final String ACCESS_OTHER = "other:";
    public static final String DEFAULT_MASK = "default:mask:";
    public static final String DEFAULT_USER = "default:user:";
    public static final String DEFAULT_GROUP = "default:group:";
    public static final String DEFAULT_OTHER = "default:other:";
    public static final String DEFAULT_SCOPE = "default:";
    public static final String PERMISSION_FORMAT = "%04d";
    public static final String SUPER_USER = "$superuser";
    public static final String HUNDRED_CONTINUE = "100-continue";
    public static final char CHAR_FORWARD_SLASH = '/';
    public static final char CHAR_EXCLAMATION_POINT = '!';
    public static final char CHAR_UNDERSCORE = '_';
    public static final char CHAR_HYPHEN = '-';
    public static final char CHAR_EQUALS = '=';
    public static final char CHAR_STAR = '*';
    public static final char CHAR_PLUS = '+';
    public static final String DECEMBER_2019_API_VERSION = "2019-12-12";
    public static final String APRIL_2021_API_VERSION = "2021-04-10";
    public static final Integer HTTP_STATUS_CATEGORY_QUOTIENT = 100;

    private AbfsHttpConstants() {
    }
}

