/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.Shell;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDFSUtil {
    static final String NS1_NN_ADDR = "ns1-nn.example.com:8020";
    static final String NS1_NN1_ADDR = "ns1-nn1.example.com:8020";
    static final String NS1_NN2_ADDR = "ns1-nn2.example.com:8020";
    static final String NS1_NN1_HTTPS_ADDR = "ns1-nn1.example.com:50740";
    static final String NS1_NN1_HTTP_ADDR = "ns1-nn1.example.com:50070";

    @Before
    public void resetUGI() {
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
    }

    @Test
    public void testLocatedBlocks2Locations() {
        DatanodeInfo d = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] ds = new DatanodeInfo[]{d};
        ExtendedBlock b1 = new ExtendedBlock("bpid", 1L, 1L, 1L);
        LocatedBlock l1 = new LocatedBlock(b1, ds);
        l1.setStartOffset(0L);
        l1.setCorrupt(false);
        ExtendedBlock b2 = new ExtendedBlock("bpid", 2L, 1L, 1L);
        LocatedBlock l2 = new LocatedBlock(b2, ds);
        l2.setStartOffset(0L);
        l2.setCorrupt(true);
        List<LocatedBlock> ls = Arrays.asList(l1, l2);
        LocatedBlocks lbs = new LocatedBlocks(10L, false, ls, l2, true, null, null);
        BlockLocation[] bs = DFSUtilClient.locatedBlocks2Locations((LocatedBlocks)lbs);
        Assert.assertTrue((String)("expected 2 blocks but got " + bs.length), (bs.length == 2 ? 1 : 0) != 0);
        int corruptCount = 0;
        for (BlockLocation b : bs) {
            if (!b.isCorrupt()) continue;
            ++corruptCount;
        }
        Assert.assertTrue((String)("expected 1 corrupt files but got " + corruptCount), (corruptCount == 1 ? 1 : 0) != 0);
        bs = DFSUtilClient.locatedBlocks2Locations((LocatedBlocks)new LocatedBlocks());
        Assert.assertEquals((long)0L, (long)bs.length);
    }

    @Test
    public void testLocatedBlockConstructorWithNullCachedLocs() {
        DatanodeInfo d = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] ds = new DatanodeInfo[]{d};
        ExtendedBlock b1 = new ExtendedBlock("bpid", 1L, 1L, 1L);
        LocatedBlock l1 = new LocatedBlock(b1, ds, null, null, 0L, false, null);
        DatanodeInfo[] cachedLocs = l1.getCachedLocations();
        Assert.assertTrue((cachedLocs.length == 0 ? 1 : 0) != 0);
    }

    private Configuration setupAddress(String key) {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "nn1");
        conf.set(DFSUtil.addKeySuffixes((String)key, (String[])new String[]{"nn1"}), "localhost:9000");
        return conf;
    }

    @Test
    public void getNameServiceId() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservice.id", "nn1");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getNamenodeNameServiceId((Configuration)conf));
    }

    @Test
    public void getNameNodeNameServiceId() {
        Configuration conf = this.setupAddress("dfs.namenode.rpc-address");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getNamenodeNameServiceId((Configuration)conf));
    }

    @Test
    public void getBackupNameServiceId() {
        Configuration conf = this.setupAddress("dfs.namenode.backup.address");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getBackupNameServiceId((Configuration)conf));
    }

    @Test
    public void getSecondaryNameServiceId() {
        Configuration conf = this.setupAddress("dfs.namenode.secondary.http-address");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getSecondaryNameServiceId((Configuration)conf));
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testGetNameServiceIdException() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"nn1"}), "localhost:9000");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"nn2"}), "localhost:9001");
        DFSUtil.getNamenodeNameServiceId((Configuration)conf);
        Assert.fail((String)"Expected exception is not thrown");
    }

    @Test
    public void testGetNameServiceIds() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "nn1,nn2");
        Collection nameserviceIds = DFSUtilClient.getNameServiceIds((Configuration)conf);
        Iterator it = nameserviceIds.iterator();
        Assert.assertEquals((long)2L, (long)nameserviceIds.size());
        Assert.assertEquals((Object)"nn1", (Object)((String)it.next()).toString());
        Assert.assertEquals((Object)"nn2", (Object)((String)it.next()).toString());
    }

    @Test
    public void testGetOnlyNameServiceIdOrNull() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "ns1,ns2");
        Assert.assertNull((Object)DFSUtil.getOnlyNameServiceIdOrNull((Configuration)conf));
        conf.set("dfs.nameservices", "");
        Assert.assertNull((Object)DFSUtil.getOnlyNameServiceIdOrNull((Configuration)conf));
        conf.set("dfs.nameservices", "ns1");
        Assert.assertEquals((Object)"ns1", (Object)DFSUtil.getOnlyNameServiceIdOrNull((Configuration)conf));
    }

    @Test
    public void testMultipleNamenodes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "nn1,nn2");
        String NN1_ADDRESS = "localhost:9000";
        String NN2_ADDRESS = "localhost:9001";
        String NN3_ADDRESS = "localhost:9002";
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"nn1"}), "localhost:9000");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"nn2"}), "localhost:9001");
        Map nnMap = DFSUtil.getNNServiceRpcAddresses((Configuration)conf);
        Assert.assertEquals((long)2L, (long)nnMap.size());
        Map nn1Map = (Map)nnMap.get("nn1");
        Assert.assertEquals((long)1L, (long)nn1Map.size());
        InetSocketAddress addr = (InetSocketAddress)nn1Map.get(null);
        Assert.assertEquals((Object)"localhost", (Object)addr.getHostName());
        Assert.assertEquals((long)9000L, (long)addr.getPort());
        Map nn2Map = (Map)nnMap.get("nn2");
        Assert.assertEquals((long)1L, (long)nn2Map.size());
        addr = (InetSocketAddress)nn2Map.get(null);
        Assert.assertEquals((Object)"localhost", (Object)addr.getHostName());
        Assert.assertEquals((long)9001L, (long)addr.getPort());
        this.checkNameServiceId((Configuration)conf, "localhost:9000", "nn1");
        this.checkNameServiceId((Configuration)conf, "localhost:9001", "nn2");
        this.checkNameServiceId((Configuration)conf, "localhost:9002", null);
        Assert.assertFalse((boolean)HAUtil.isHAEnabled((Configuration)conf, (String)"nn1"));
        Assert.assertFalse((boolean)HAUtil.isHAEnabled((Configuration)conf, (String)"nn2"));
    }

    public void checkNameServiceId(Configuration conf, String addr, String expectedNameServiceId) {
        InetSocketAddress s = NetUtils.createSocketAddr((String)addr);
        String nameserviceId = DFSUtil.getNameServiceIdFromAddress((Configuration)conf, (InetSocketAddress)s, (String[])new String[]{"dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address"});
        Assert.assertEquals((Object)expectedNameServiceId, (Object)nameserviceId);
    }

    @Test
    public void testDefaultNamenode() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String hdfs_default = "hdfs://localhost:9999/";
        conf.set("fs.defaultFS", "hdfs://localhost:9999/");
        Map addrMap = DFSUtil.getNNServiceRpcAddresses((Configuration)conf);
        Assert.assertEquals((long)1L, (long)addrMap.size());
        Map defaultNsMap = (Map)addrMap.get(null);
        Assert.assertEquals((long)1L, (long)defaultNsMap.size());
        Assert.assertEquals((long)9999L, (long)((InetSocketAddress)defaultNsMap.get(null)).getPort());
    }

    @Test
    public void testConfModificationFederationOnly() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String nsId = "ns1";
        conf.set("dfs.nameservices", nsId);
        conf.set("dfs.nameservice.id", nsId);
        for (String key : NameNode.NAMENODE_SPECIFIC_KEYS) {
            conf.set(DFSUtil.addKeySuffixes((String)key, (String[])new String[]{nsId}), key);
        }
        NameNode.initializeGenericKeys((Configuration)conf, (String)nsId, null);
        for (String key : NameNode.NAMENODE_SPECIFIC_KEYS) {
            Assert.assertEquals((Object)key, (Object)conf.get(key));
        }
    }

    @Test
    public void testConfModificationFederationAndHa() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String nsId = "ns1";
        String nnId = "nn1";
        conf.set("dfs.nameservices", nsId);
        conf.set("dfs.nameservice.id", nsId);
        conf.set("dfs.ha.namenodes." + nsId, nnId);
        for (String key : NameNode.NAMENODE_SPECIFIC_KEYS) {
            conf.set(DFSUtil.addKeySuffixes((String)key, (String[])new String[]{nsId, nnId}), key);
        }
        NameNode.initializeGenericKeys((Configuration)conf, (String)nsId, (String)nnId);
        for (String key : NameNode.NAMENODE_SPECIFIC_KEYS) {
            Assert.assertEquals((Object)key, (Object)conf.get(key));
        }
    }

    @Test
    public void testConfModificationNoFederationOrHa() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String nsId = null;
        String nnId = null;
        conf.set("dfs.namenode.rpc-address", "localhost:1234");
        Assert.assertFalse((boolean)"hdfs://localhost:1234".equals(conf.get("fs.defaultFS")));
        NameNode.initializeGenericKeys((Configuration)conf, nsId, nnId);
        Assert.assertEquals((Object)"hdfs://localhost:1234", (Object)conf.get("fs.defaultFS"));
    }

    @Test
    public void testSomeConfsNNSpecificSomeNSSpecific() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String key = "dfs.namenode.shared.edits.dir";
        conf.set(key, "global-default");
        conf.set(key + ".ns1", "ns1-override");
        conf.set(key + ".ns1.nn1", "nn1-override");
        Configuration newConf = new Configuration((Configuration)conf);
        NameNode.initializeGenericKeys((Configuration)newConf, (String)"ns2", (String)"nn1");
        Assert.assertEquals((Object)"global-default", (Object)newConf.get(key));
        newConf = new Configuration((Configuration)conf);
        NameNode.initializeGenericKeys((Configuration)newConf, (String)"ns2", null);
        Assert.assertEquals((Object)"global-default", (Object)newConf.get(key));
        newConf = new Configuration((Configuration)conf);
        NameNode.initializeGenericKeys((Configuration)newConf, (String)"ns1", (String)"nn2");
        Assert.assertEquals((Object)"ns1-override", (Object)newConf.get(key));
        newConf = new Configuration((Configuration)conf);
        NameNode.initializeGenericKeys((Configuration)newConf, (String)"ns1", (String)"nn1");
        Assert.assertEquals((Object)"nn1-override", (Object)newConf.get(key));
    }

    @Test
    public void testEmptyConf() {
        Map map2;
        HdfsConfiguration conf = new HdfsConfiguration(false);
        try {
            map2 = DFSUtil.getNNServiceRpcAddresses((Configuration)conf);
            Assert.fail((String)("Expected IOException is not thrown, result was: " + DFSUtil.addressMapToString((Map)map2)));
        }
        catch (IOException map2) {
            // empty catch block
        }
        try {
            map2 = DFSUtil.getBackupNodeAddresses((Configuration)conf);
            Assert.fail((String)("Expected IOException is not thrown, result was: " + DFSUtil.addressMapToString((Map)map2)));
        }
        catch (IOException map3) {
            // empty catch block
        }
        try {
            map2 = DFSUtil.getSecondaryNameNodeAddresses((Configuration)conf);
            Assert.fail((String)("Expected IOException is not thrown, result was: " + DFSUtil.addressMapToString((Map)map2)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNamenodeWebAddr() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.https-address", (String[])new String[]{"ns1", "nn1"}), NS1_NN1_HTTPS_ADDR);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.http-address", (String[])new String[]{"ns1", "nn1"}), NS1_NN1_HTTP_ADDR);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        String httpsOnlyWebAddr = DFSUtil.getNamenodeWebAddr((Configuration)conf, (String)"ns1", (String)"nn1");
        Assert.assertEquals((Object)NS1_NN1_HTTPS_ADDR, (Object)httpsOnlyWebAddr);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTP_ONLY.name());
        String httpOnlyWebAddr = DFSUtil.getNamenodeWebAddr((Configuration)conf, (String)"ns1", (String)"nn1");
        Assert.assertEquals((Object)NS1_NN1_HTTP_ADDR, (Object)httpOnlyWebAddr);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTP_AND_HTTPS.name());
        String httpAndHttpsWebAddr = DFSUtil.getNamenodeWebAddr((Configuration)conf, (String)"ns1", (String)"nn1");
        Assert.assertEquals((Object)NS1_NN1_HTTP_ADDR, (Object)httpAndHttpsWebAddr);
    }

    @Test
    public void testGetInfoServer() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        URI httpsport = DFSUtil.getInfoServer(null, (Configuration)conf, (String)"https");
        Assert.assertEquals((Object)new URI("https", null, "0.0.0.0", 9871, null, null, null), (Object)httpsport);
        URI httpport = DFSUtil.getInfoServer(null, (Configuration)conf, (String)"http");
        Assert.assertEquals((Object)new URI("http", null, "0.0.0.0", 9870, null, null, null), (Object)httpport);
        URI httpAddress = DFSUtil.getInfoServer((InetSocketAddress)new InetSocketAddress("localhost", 8020), (Configuration)conf, (String)"http");
        Assert.assertEquals((Object)URI.create("http://localhost:9870"), (Object)httpAddress);
    }

    @Test
    public void testHANameNodesWithFederation() throws URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String NS1_NN1_HOST = NS1_NN1_ADDR;
        String NS1_NN2_HOST = NS1_NN2_ADDR;
        String NS2_NN1_HOST = "ns2-nn1.example.com:8020";
        String NS2_NN2_HOST = "ns2-nn2.example.com:8020";
        conf.set("fs.defaultFS", "hdfs://ns1");
        conf.set("dfs.nameservices", "ns1,ns2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{"ns1"}), "ns1-nn1,ns1-nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{"ns2"}), "ns2-nn1,ns2-nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "ns1-nn1"}), NS1_NN1_ADDR);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "ns1-nn2"}), NS1_NN2_ADDR);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns2", "ns2-nn1"}), "ns2-nn1.example.com:8020");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns2", "ns2-nn2"}), "ns2-nn2.example.com:8020");
        Map map = DFSUtilClient.getHaNnRpcAddresses((Configuration)conf);
        Assert.assertTrue((boolean)HAUtil.isHAEnabled((Configuration)conf, (String)"ns1"));
        Assert.assertTrue((boolean)HAUtil.isHAEnabled((Configuration)conf, (String)"ns2"));
        Assert.assertFalse((boolean)HAUtil.isHAEnabled((Configuration)conf, (String)"ns3"));
        Assert.assertEquals((Object)NS1_NN1_ADDR, (Object)((InetSocketAddress)((Map)map.get("ns1")).get("ns1-nn1")).toString());
        Assert.assertEquals((Object)NS1_NN2_ADDR, (Object)((InetSocketAddress)((Map)map.get("ns1")).get("ns1-nn2")).toString());
        Assert.assertEquals((Object)"ns2-nn1.example.com:8020", (Object)((InetSocketAddress)((Map)map.get("ns2")).get("ns2-nn1")).toString());
        Assert.assertEquals((Object)"ns2-nn2.example.com:8020", (Object)((InetSocketAddress)((Map)map.get("ns2")).get("ns2-nn2")).toString());
        Assert.assertEquals((Object)NS1_NN1_ADDR, (Object)DFSUtil.getNamenodeServiceAddr((Configuration)conf, (String)"ns1", (String)"ns1-nn1"));
        Assert.assertEquals((Object)NS1_NN2_ADDR, (Object)DFSUtil.getNamenodeServiceAddr((Configuration)conf, (String)"ns1", (String)"ns1-nn2"));
        Assert.assertEquals((Object)"ns2-nn1.example.com:8020", (Object)DFSUtil.getNamenodeServiceAddr((Configuration)conf, (String)"ns2", (String)"ns2-nn1"));
        Assert.assertEquals(null, (Object)DFSUtil.getNamenodeServiceAddr((Configuration)conf, null, (String)"ns1-nn1"));
        Assert.assertEquals(null, (Object)DFSUtil.getNamenodeNameServiceId((Configuration)conf));
        Assert.assertEquals(null, (Object)DFSUtil.getSecondaryNameServiceId((Configuration)conf));
        String proxyProviderKey = "dfs.client.failover.proxy.provider.ns2";
        conf.set(proxyProviderKey, "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider");
        Collection<URI> uris = TestDFSUtil.getInternalNameServiceUris((Configuration)conf, "dfs.namenode.rpc-address");
        Assert.assertEquals((long)2L, (long)uris.size());
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://ns1")));
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://ns2")));
    }

    @Test
    public void getNameNodeServiceAddr() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String NS1_NN1_HOST = NS1_NN1_ADDR;
        String NS1_NN1_HOST_SVC = "ns1-nn2.example.com:9821";
        String NS1_NN2_HOST = NS1_NN1_ADDR;
        String NS1_NN2_HOST_SVC = "ns1-nn2.example.com:9821";
        conf.set("dfs.nameservices", "ns1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{"ns1"}), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn1"}), NS1_NN1_ADDR);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn2"}), NS1_NN1_ADDR);
        Assert.assertEquals((Object)NS1_NN1_ADDR, (Object)DFSUtil.getNamenodeServiceAddr((Configuration)conf, null, (String)"nn1"));
        Assert.assertEquals((Object)NS1_NN1_ADDR, (Object)DFSUtil.getNamenodeServiceAddr((Configuration)conf, null, (String)"nn2"));
        Assert.assertEquals((Object)NS1_NN1_ADDR, (Object)DFSUtil.getNamenodeServiceAddr((Configuration)conf, (String)"ns1", (String)"nn1"));
        Assert.assertEquals(null, (Object)DFSUtil.getNamenodeServiceAddr((Configuration)conf, (String)"invalid", (String)"nn1"));
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.servicerpc-address", (String[])new String[]{"ns1", "nn1"}), "ns1-nn2.example.com:9821");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.servicerpc-address", (String[])new String[]{"ns1", "nn2"}), "ns1-nn2.example.com:9821");
        Assert.assertEquals((Object)"ns1-nn2.example.com:9821", (Object)DFSUtil.getNamenodeServiceAddr((Configuration)conf, null, (String)"nn1"));
        Assert.assertEquals((Object)"ns1-nn2.example.com:9821", (Object)DFSUtil.getNamenodeServiceAddr((Configuration)conf, null, (String)"nn2"));
        Assert.assertEquals((Object)"ns1", (Object)DFSUtil.getNamenodeNameServiceId((Configuration)conf));
        Assert.assertEquals((Object)"ns1", (Object)DFSUtil.getSecondaryNameServiceId((Configuration)conf));
    }

    @Test
    public void testGetHaNnHttpAddresses() throws IOException {
        String LOGICAL_HOST_NAME = "ns1";
        Configuration conf = TestDFSUtil.createWebHDFSHAConfiguration("ns1", NS1_NN1_ADDR, NS1_NN2_ADDR);
        Map map = DFSUtilClient.getHaNnWebHdfsAddresses((Configuration)conf, (String)"webhdfs");
        Assert.assertEquals((Object)NS1_NN1_ADDR, (Object)((InetSocketAddress)((Map)map.get("ns1")).get("nn1")).toString());
        Assert.assertEquals((Object)NS1_NN2_ADDR, (Object)((InetSocketAddress)((Map)map.get("ns1")).get("nn2")).toString());
    }

    private static Configuration createWebHDFSHAConfiguration(String logicalHostName, String nnaddr1, String nnaddr2) {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "ns1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{"ns1"}), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.http-address", (String[])new String[]{"ns1", "nn1"}), nnaddr1);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.http-address", (String[])new String[]{"ns1", "nn2"}), nnaddr2);
        conf.set("dfs.client.failover.proxy.provider." + logicalHostName, ConfiguredFailoverProxyProvider.class.getName());
        return conf;
    }

    @Test
    public void testSubstituteForWildcardAddress() throws IOException {
        Assert.assertEquals((Object)"foo:12345", (Object)DFSUtil.substituteForWildcardAddress((String)"0.0.0.0:12345", (String)"foo"));
        Assert.assertEquals((Object)"127.0.0.1:12345", (Object)DFSUtil.substituteForWildcardAddress((String)"127.0.0.1:12345", (String)"foo"));
    }

    private static Collection<URI> getInternalNameServiceUris(Configuration conf, String ... keys) {
        Collection ids = DFSUtil.getInternalNameServices((Configuration)conf);
        return DFSUtil.getNameServiceUris((Configuration)conf, (Collection)ids, (String[])keys);
    }

    @Test
    public void testGetNNUris() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String NS2_NN_ADDR = "ns2-nn.example.com:8020";
        String NN1_ADDR = "nn.example.com:8020";
        String NN1_SRVC_ADDR = "nn.example.com:9821";
        String NN2_ADDR = "nn2.example.com:8020";
        conf.set("dfs.nameservices", "ns1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.servicerpc-address", (String[])new String[]{"ns1"}), NS1_NN1_ADDR);
        conf.set("dfs.namenode.servicerpc-address", "hdfs://nn2.example.com:8020");
        conf.set("fs.defaultFS", "hdfs://nn.example.com:8020");
        Collection uris = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((String)"Incorrect number of URIs returned", (long)2L, (long)uris.size());
        Assert.assertTrue((String)"Missing URI for name service ns1", (boolean)uris.contains(new URI("hdfs://ns1-nn1.example.com:8020")));
        Assert.assertTrue((String)"Missing URI for service address", (boolean)uris.contains(new URI("hdfs://nn2.example.com:8020")));
        conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "ns1,ns2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{"ns1"}), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn1"}), NS1_NN1_ADDR);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn2"}), NS1_NN2_ADDR);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.servicerpc-address", (String[])new String[]{"ns1"}), NS1_NN_ADDR);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.servicerpc-address", (String[])new String[]{"ns2"}), "ns2-nn.example.com:8020");
        conf.set("dfs.namenode.rpc-address", "hdfs://nn.example.com:8020");
        conf.set("fs.defaultFS", "hdfs://nn2.example.com:8020");
        String proxyProviderKey = "dfs.client.failover.proxy.provider.ns1";
        conf.set(proxyProviderKey, "org.apache.hadoop.hdfs.server.namenode.ha.IPFailoverProxyProvider");
        uris = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((String)"Incorrect number of URIs returned", (long)3L, (long)uris.size());
        Assert.assertTrue((String)"Missing URI for RPC address", (boolean)uris.contains(new URI("hdfs://nn.example.com:8020")));
        Assert.assertTrue((String)"Missing URI for name service ns2", (boolean)uris.contains(new URI("hdfs://ns1-nn.example.com:8020")));
        Assert.assertTrue((String)"Missing URI for name service ns2", (boolean)uris.contains(new URI("hdfs://ns2-nn.example.com:8020")));
        conf.set(proxyProviderKey, "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider");
        uris = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((String)"Incorrect number of URIs returned", (long)3L, (long)uris.size());
        Assert.assertTrue((String)"Missing URI for name service ns1", (boolean)uris.contains(new URI("hdfs://ns1")));
        Assert.assertTrue((String)"Missing URI for name service ns2", (boolean)uris.contains(new URI("hdfs://ns2-nn.example.com:8020")));
        Assert.assertTrue((String)"Missing URI for RPC address", (boolean)uris.contains(new URI("hdfs://nn.example.com:8020")));
        conf.set("fs.defaultFS", "viewfs://vfs-name.example.com");
        uris = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((String)"Incorrect number of URIs returned", (long)3L, (long)uris.size());
        Assert.assertTrue((String)"Missing URI for name service ns1", (boolean)uris.contains(new URI("hdfs://ns1")));
        Assert.assertTrue((String)"Missing URI for name service ns2", (boolean)uris.contains(new URI("hdfs://ns2-nn.example.com:8020")));
        Assert.assertTrue((String)"Missing URI for RPC address", (boolean)uris.contains(new URI("hdfs://nn.example.com:8020")));
        conf.set("fs.defaultFS", "hdfs://ns1");
        uris = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((String)"Incorrect number of URIs returned", (long)3L, (long)uris.size());
        Assert.assertTrue((String)"Missing URI for name service ns1", (boolean)uris.contains(new URI("hdfs://ns1")));
        Assert.assertTrue((String)"Missing URI for name service ns2", (boolean)uris.contains(new URI("hdfs://ns2-nn.example.com:8020")));
        Assert.assertTrue((String)"Missing URI for RPC address", (boolean)uris.contains(new URI("hdfs://nn.example.com:8020")));
        conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://nn.example.com:8020");
        uris = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((String)"Incorrect number of URIs returned", (long)1L, (long)uris.size());
        Assert.assertTrue((String)"Missing URI for RPC address (defaultFS)", (boolean)uris.contains(new URI("hdfs://nn.example.com:8020")));
        conf.set("dfs.namenode.rpc-address", "nn2.example.com:8020");
        uris = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((String)"Incorrect number of URIs returned", (long)1L, (long)uris.size());
        Assert.assertTrue((String)"Missing URI for RPC address", (boolean)uris.contains(new URI("hdfs://nn2.example.com:8020")));
        conf.set("dfs.namenode.servicerpc-address", "nn.example.com:8020");
        uris = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((String)"Incorrect number of URIs returned", (long)1L, (long)uris.size());
        Assert.assertTrue((String)"Missing URI for service ns1", (boolean)uris.contains(new URI("hdfs://nn.example.com:8020")));
        conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://nn.example.com:8020");
        conf.set("dfs.namenode.servicerpc-address", "nn.example.com:9821");
        uris = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((String)"Incorrect number of URIs returned", (long)1L, (long)uris.size());
        Assert.assertTrue((String)"Missing URI for service address", (boolean)uris.contains(new URI("hdfs://nn.example.com:9821")));
    }

    @Test
    public void testGetNNUris2() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "ns1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{"ns1"}), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn1"}), NS1_NN1_ADDR);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn2"}), NS1_NN2_ADDR);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.servicerpc-address", (String[])new String[]{"ns1"}), NS1_NN_ADDR);
        String proxyProviderKey = "dfs.client.failover.proxy.provider.ns1";
        conf.set(proxyProviderKey, "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider");
        conf.set("fs.defaultFS", "hdfs://ns1/");
        Collection uris = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((String)"Incorrect number of URIs returned", (long)1L, (long)uris.size());
        Assert.assertTrue((String)"Missing URI for name service ns1", (boolean)uris.contains(new URI("hdfs://ns1")));
    }

    @Test(timeout=15000L)
    public void testLocalhostReverseLookup() {
        PlatformAssumptions.assumeNotWindows();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://127.0.0.1:8020");
        Collection<URI> uris = TestDFSUtil.getInternalNameServiceUris((Configuration)conf, new String[0]);
        Assert.assertEquals((long)1L, (long)uris.size());
        for (URI uri : uris) {
            Assert.assertThat((Object)uri.getHost(), (Matcher)CoreMatchers.not((Object)"127.0.0.1"));
        }
    }

    @Test(timeout=15000L)
    public void testIsValidName() {
        String[] invalidPaths;
        String[] validPaths;
        for (String path : validPaths = new String[]{"/", "/bar/"}) {
            Assert.assertTrue((String)("Should have been accepted '" + path + "'"), (boolean)DFSUtil.isValidName((String)path));
        }
        for (String path : invalidPaths = new String[]{"/foo/../bar", "/foo/./bar", "/foo//bar", "/foo/:/bar", "/foo:bar"}) {
            Assert.assertFalse((String)("Should have been rejected '" + path + "'"), (boolean)DFSUtil.isValidName((String)path));
        }
        String windowsPath = "/C:/foo/bar";
        if (Shell.WINDOWS) {
            Assert.assertTrue((String)("Should have been accepted '" + windowsPath + "' in windows os."), (boolean)DFSUtil.isValidName((String)windowsPath));
        } else {
            Assert.assertFalse((String)("Should have been rejected '" + windowsPath + "' in unix os."), (boolean)DFSUtil.isValidName((String)windowsPath));
        }
    }

    @Test(timeout=5000L)
    public void testGetSpnegoKeytabKey() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String defaultKey = "default.spengo.key";
        conf.unset("dfs.web.authentication.kerberos.keytab");
        Assert.assertEquals((String)"Test spnego key in config is null", (Object)defaultKey, (Object)DFSUtil.getSpnegoKeytabKey((Configuration)conf, (String)defaultKey));
        conf.set("dfs.web.authentication.kerberos.keytab", "");
        Assert.assertEquals((String)"Test spnego key is empty", (Object)defaultKey, (Object)DFSUtil.getSpnegoKeytabKey((Configuration)conf, (String)defaultKey));
        String spengoKey = "spengo.key";
        conf.set("dfs.web.authentication.kerberos.keytab", spengoKey);
        Assert.assertEquals((String)"Test spnego key is NOT null", (Object)"dfs.web.authentication.kerberos.keytab", (Object)DFSUtil.getSpnegoKeytabKey((Configuration)conf, (String)defaultKey));
    }

    @Test(timeout=10000L)
    public void testDurationToString() throws Exception {
        Assert.assertEquals((Object)"000:00:00:00.000", (Object)DFSUtil.durationToString((long)0L));
        Assert.assertEquals((Object)"001:01:01:01.000", (Object)DFSUtil.durationToString((long)90061000L));
        Assert.assertEquals((Object)"000:23:59:59.999", (Object)DFSUtil.durationToString((long)86399999L));
        Assert.assertEquals((Object)"-001:01:01:01.000", (Object)DFSUtil.durationToString((long)-90061000L));
        Assert.assertEquals((Object)"-000:23:59:59.574", (Object)DFSUtil.durationToString((long)-86399574L));
    }

    @Test(timeout=5000L)
    public void testRelativeTimeConversion() throws Exception {
        try {
            DFSUtil.parseRelativeTime((String)"1");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"too short", (Throwable)e);
        }
        try {
            DFSUtil.parseRelativeTime((String)"1z");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"unknown time unit", (Throwable)e);
        }
        try {
            DFSUtil.parseRelativeTime((String)"yyz");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"is not a number", (Throwable)e);
        }
        Assert.assertEquals((long)61000L, (long)DFSUtil.parseRelativeTime((String)"61s"));
        Assert.assertEquals((long)3660000L, (long)DFSUtil.parseRelativeTime((String)"61m"));
        Assert.assertEquals((long)0L, (long)DFSUtil.parseRelativeTime((String)"0s"));
        Assert.assertEquals((long)90000000L, (long)DFSUtil.parseRelativeTime((String)"25h"));
        Assert.assertEquals((long)345600000L, (long)DFSUtil.parseRelativeTime((String)"4d"));
        Assert.assertEquals((long)86313600000L, (long)DFSUtil.parseRelativeTime((String)"999d"));
    }

    @Test
    public void testAssertAllResultsEqual() {
        TestDFSUtil.checkAllResults(new Long[0], true);
        TestDFSUtil.checkAllResults(new Long[]{1L}, true);
        TestDFSUtil.checkAllResults(new Long[]{1L, 1L}, true);
        TestDFSUtil.checkAllResults(new Long[]{1L, 1L, 1L}, true);
        TestDFSUtil.checkAllResults(new Long[]{new Long(1L), new Long(1L)}, true);
        TestDFSUtil.checkAllResults(new Long[]{null, null, null}, true);
        TestDFSUtil.checkAllResults(new Long[]{1L, 2L}, false);
        TestDFSUtil.checkAllResults(new Long[]{2L, 1L}, false);
        TestDFSUtil.checkAllResults(new Long[]{1L, 2L, 1L}, false);
        TestDFSUtil.checkAllResults(new Long[]{2L, 1L, 1L}, false);
        TestDFSUtil.checkAllResults(new Long[]{1L, 1L, 2L}, false);
        TestDFSUtil.checkAllResults(new Long[]{1L, null}, false);
        TestDFSUtil.checkAllResults(new Long[]{null, 1L}, false);
        TestDFSUtil.checkAllResults(new Long[]{1L, null, 1L}, false);
    }

    private static void checkAllResults(Long[] toCheck, boolean shouldSucceed) {
        if (shouldSucceed) {
            DFSUtil.assertAllResultsEqual(Arrays.asList(toCheck));
        } else {
            try {
                DFSUtil.assertAllResultsEqual(Arrays.asList(toCheck));
                Assert.fail((String)("Should not have succeeded with input: " + Arrays.toString((Object[])toCheck)));
            }
            catch (AssertionError ae) {
                GenericTestUtils.assertExceptionContains((String)"Not all elements match", (Throwable)((Object)ae));
            }
        }
    }

    @Test
    public void testGetPassword() throws Exception {
        File testDir = GenericTestUtils.getTestDir();
        Configuration conf = new Configuration();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] keypass = new char[]{'k', 'e', 'y', 'p', 'a', 's', 's'};
        char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
        char[] trustpass = new char[]{'t', 'r', 'u', 's', 't', 'p', 'a', 's', 's'};
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.keystore.keypassword"));
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.keystore.password"));
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.truststore.password"));
        try {
            provider.createCredentialEntry("ssl.server.keystore.keypassword", keypass);
            provider.createCredentialEntry("ssl.server.keystore.password", storepass);
            provider.createCredentialEntry("ssl.server.truststore.password", trustpass);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        Assert.assertArrayEquals((char[])keypass, (char[])provider.getCredentialEntry("ssl.server.keystore.keypassword").getCredential());
        Assert.assertArrayEquals((char[])storepass, (char[])provider.getCredentialEntry("ssl.server.keystore.password").getCredential());
        Assert.assertArrayEquals((char[])trustpass, (char[])provider.getCredentialEntry("ssl.server.truststore.password").getCredential());
        Assert.assertEquals((Object)"keypass", (Object)DFSUtil.getPassword((Configuration)conf, (String)"ssl.server.keystore.keypassword"));
        Assert.assertEquals((Object)"storepass", (Object)DFSUtil.getPassword((Configuration)conf, (String)"ssl.server.keystore.password"));
        Assert.assertEquals((Object)"trustpass", (Object)DFSUtil.getPassword((Configuration)conf, (String)"ssl.server.truststore.password"));
        Assert.assertEquals(null, (Object)DFSUtil.getPassword((Configuration)conf, (String)"invalid-alias"));
    }

    @Test
    public void testGetNNServiceRpcAddressesForNsIds() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "nn1,nn2");
        conf.set("dfs.internal.nameservices", "nn1");
        String NN1_ADDRESS = "localhost:9000";
        String NN2_ADDRESS = "localhost:9001";
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"nn1"}), "localhost:9000");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"nn2"}), "localhost:9001");
        Collection internal = DFSUtil.getInternalNameServices((Configuration)conf);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("nn1")), (Object)internal);
        Collection all = DFSUtilClient.getNameServiceIds((Configuration)conf);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("nn1", "nn2")), (Object)all);
        Map nnMap = DFSUtil.getNNServiceRpcAddressesForCluster((Configuration)conf);
        Assert.assertEquals((long)1L, (long)nnMap.size());
        Assert.assertTrue((boolean)nnMap.containsKey("nn1"));
        conf.set("dfs.internal.nameservices", "nn3");
        try {
            DFSUtil.getNNServiceRpcAddressesForCluster((Configuration)conf);
            Assert.fail((String)"Should fail for misconfiguration");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testEncryptionProbe() throws Throwable {
        Configuration conf = new Configuration(false);
        conf.unset("hadoop.security.key.provider.path");
        Assert.assertFalse((String)"encryption enabled on no provider key", (boolean)DFSUtilClient.isHDFSEncryptionEnabled((Configuration)conf));
        conf.set("hadoop.security.key.provider.path", "");
        Assert.assertFalse((String)"encryption enabled on empty provider key", (boolean)DFSUtilClient.isHDFSEncryptionEnabled((Configuration)conf));
        conf.set("hadoop.security.key.provider.path", "\n\t\n");
        Assert.assertFalse((String)"encryption enabled on whitespace provider key", (boolean)DFSUtilClient.isHDFSEncryptionEnabled((Configuration)conf));
        conf.set("hadoop.security.key.provider.path", "http://hadoop.apache.org");
        Assert.assertTrue((String)"encryption disabled on valid provider key", (boolean)DFSUtilClient.isHDFSEncryptionEnabled((Configuration)conf));
    }

    @Test
    public void testFileIdPath() throws Throwable {
        String prefix = "/.reserved/.inodes/";
        Random r = new Random();
        for (int i = 0; i < 100; ++i) {
            long inode = r.nextLong() & Long.MAX_VALUE;
            Assert.assertEquals((Object)new Path(prefix + inode), (Object)DFSUtilClient.makePathFromFileId((long)inode));
        }
    }

    @Test
    public void testErrorMessageForInvalidNameservice() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "ns1, ns2");
        String expectedErrorMessage = "Incorrect configuration: namenode address dfs.namenode.servicerpc-address.[ns1, ns2] or dfs.namenode.rpc-address.[ns1, ns2] is not configured.";
        LambdaTestUtils.intercept(IOException.class, (String)expectedErrorMessage, () -> TestDFSUtil.lambda$testErrorMessageForInvalidNameservice$0((Configuration)conf));
    }

    @Test
    public void testAddTransferRateMetricForValidValues() {
        DataNodeMetrics mockMetrics = (DataNodeMetrics)Mockito.mock(DataNodeMetrics.class);
        DFSUtil.addTransferRateMetric((DataNodeMetrics)mockMetrics, (long)3251854872L, (long)129593000000L);
        ((DataNodeMetrics)Mockito.verify((Object)mockMetrics)).addReadTransferRate(25092828L);
    }

    @Test
    public void testAddTransferRateMetricForZeroNSTransferDuration() {
        DataNodeMetrics mockMetrics = (DataNodeMetrics)Mockito.mock(DataNodeMetrics.class);
        DFSUtil.addTransferRateMetric((DataNodeMetrics)mockMetrics, (long)1L, (long)0L);
        ((DataNodeMetrics)Mockito.verify((Object)mockMetrics)).addReadTransferRate(999999999L);
    }

    @Test
    public void testAddTransferRateMetricNegativeTransferBytes() {
        DataNodeMetrics mockMetrics = (DataNodeMetrics)Mockito.mock(DataNodeMetrics.class);
        DFSUtil.addTransferRateMetric((DataNodeMetrics)mockMetrics, (long)-1L, (long)0L);
        ((DataNodeMetrics)Mockito.verify((Object)mockMetrics)).addReadTransferRate(0L);
    }

    @Test
    public void testAddTransferRateMetricZeroTransferBytes() {
        DataNodeMetrics mockMetrics = (DataNodeMetrics)Mockito.mock(DataNodeMetrics.class);
        DFSUtil.addTransferRateMetric((DataNodeMetrics)mockMetrics, (long)-1L, (long)0L);
        ((DataNodeMetrics)Mockito.verify((Object)mockMetrics)).addReadTransferRate(0L);
    }

    @Test
    public void testGetTransferRateInBytesPerSecond() {
        Assert.assertEquals((long)999999999L, (long)DFSUtil.getTransferRateInBytesPerSecond((long)1L, (long)1L));
        Assert.assertEquals((long)999999999L, (long)DFSUtil.getTransferRateInBytesPerSecond((long)1L, (long)0L));
        Assert.assertEquals((long)102400000L, (long)DFSUtil.getTransferRateInBytesPerSecond((long)512000000L, (long)5000000000L));
    }

    private static /* synthetic */ Map lambda$testErrorMessageForInvalidNameservice$0(Configuration conf) throws Exception {
        return DFSUtil.getNNServiceRpcAddressesForCluster((Configuration)conf);
    }
}

