/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.PhysicalStore;

final class WrapperStore<N extends Number>
extends FactoryStore<N> {
    private final Access2D<?> myAccess;

    private WrapperStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myAccess = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    WrapperStore(PhysicalStore.Factory<N, ?> factory, Access2D<?> access) {
        super(factory, (int)access.countRows(), (int)access.countColumns());
        this.myAccess = access;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return this.myAccess.doubleValue(aRow, aCol);
    }

    @Override
    public N get(long aRow, long aCol) {
        return this.physical().scalar().cast((Number)this.myAccess.get(aRow, aCol));
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        this.addNonzerosTo(receiver);
    }

    @Override
    protected void addNonzerosTo(ElementsConsumer<N> consumer) {
        consumer.fillMatching(this.myAccess);
    }
}

