/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.portmap;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.portmap.RpcProgramPortmap;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Portmap {
    private static final Logger LOG = LoggerFactory.getLogger(Portmap.class);
    private static final int DEFAULT_IDLE_TIME_MILLISECONDS = 5000;
    private Bootstrap udpServer;
    private ServerBootstrap tcpServer;
    private ChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private Channel udpChannel;
    private Channel tcpChannel;
    EventLoopGroup bossGroup;
    EventLoopGroup workerGroup;
    EventLoopGroup udpGroup;
    private final RpcProgramPortmap handler = new RpcProgramPortmap(this.allChannels);

    Portmap() {
    }

    public static void main(String[] args) {
        StringUtils.startupShutdownMessage(Portmap.class, (String[])args, (Logger)LOG);
        int port = 111;
        Portmap pm = new Portmap();
        try {
            pm.start(5000, new InetSocketAddress(111), new InetSocketAddress(111));
        }
        catch (Throwable e) {
            LOG.error("Failed to start the server. Cause:", e);
            pm.shutdown();
            System.exit(-1);
        }
    }

    void shutdown() {
        this.allChannels.close().awaitUninterruptibly();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.udpGroup.shutdownGracefully();
    }

    @VisibleForTesting
    SocketAddress getTcpServerLocalAddress() {
        return this.tcpChannel.localAddress();
    }

    @VisibleForTesting
    SocketAddress getUdpServerLoAddress() {
        return this.udpChannel.localAddress();
    }

    @VisibleForTesting
    RpcProgramPortmap getHandler() {
        return this.handler;
    }

    void start(final int idleTimeMilliSeconds, SocketAddress tcpAddress, SocketAddress udpAddress) throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup(0, (Executor)Executors.newCachedThreadPool());
        this.tcpServer = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)this.tcpServer.group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_REUSEADDR, (Object)true).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{RpcUtil.constructRpcFrameDecoder(), RpcUtil.STAGE_RPC_MESSAGE_PARSER, new IdleStateHandler(0L, 0L, (long)idleTimeMilliSeconds, TimeUnit.MILLISECONDS), Portmap.this.handler, RpcUtil.STAGE_RPC_TCP_RESPONSE});
            }
        });
        this.udpGroup = new NioEventLoopGroup(0, (Executor)Executors.newCachedThreadPool());
        this.udpServer = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)this.udpServer.group(this.udpGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

            protected void initChannel(NioDatagramChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG), RpcUtil.STAGE_RPC_MESSAGE_PARSER, Portmap.this.handler, RpcUtil.STAGE_RPC_UDP_RESPONSE});
            }
        })).option(ChannelOption.SO_REUSEADDR, (Object)true);
        ChannelFuture tcpChannelFuture = null;
        tcpChannelFuture = this.tcpServer.bind(tcpAddress);
        ChannelFuture udpChannelFuture = this.udpServer.bind(udpAddress);
        this.tcpChannel = tcpChannelFuture.sync().channel();
        this.udpChannel = udpChannelFuture.sync().channel();
        this.allChannels.add((Object)this.tcpChannel);
        this.allChannels.add((Object)this.udpChannel);
        LOG.info("Portmap server started at tcp://" + this.tcpChannel.localAddress() + ", udp://" + this.udpChannel.localAddress());
    }
}

