/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.tools.StoragePolicyAdmin;
import org.apache.hadoop.hdfs.tools.TestStoragePolicyCommands;
import org.apache.hadoop.util.Tool;
import org.junit.Before;
import org.junit.Test;

public class TestViewFSStoragePolicyCommands
extends TestStoragePolicyCommands {
    @Override
    @Before
    public void clusterSetUp() throws IOException {
        conf = new HdfsConfiguration();
        String clusterName = "cluster";
        cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(2).build();
        cluster.waitActive();
        DistributedFileSystem hdfs1 = cluster.getFileSystem(0);
        DistributedFileSystem hdfs2 = cluster.getFileSystem(1);
        conf.set("fs.defaultFS", "viewfs://" + clusterName);
        Path base1 = new Path("/user1");
        Path base2 = new Path("/user2");
        hdfs1.delete(base1, true);
        hdfs2.delete(base2, true);
        hdfs1.mkdirs(base1);
        hdfs2.mkdirs(base2);
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/foo", (URI)hdfs1.makeQualified(base1).toUri());
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/hdfs2", (URI)hdfs2.makeQualified(base2).toUri());
        fs = FileSystem.get((Configuration)conf);
    }

    @Test
    public void testStoragePolicyRoot() throws Exception {
        StoragePolicyAdmin admin = new StoragePolicyAdmin(conf);
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /", 2, "is not supported for filesystem viewfs on path /");
    }

    @Test
    public void testStoragePolicyCommandPathWithSchema() throws Exception {
        Path base1 = new Path("/user1");
        Path bar = new Path(base1, "bar");
        DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(0), bar, 1024L, (short)1, 0L);
        String pathHdfsSchema = "hdfs://" + cluster.getNameNode(0).getClientNamenodeAddress() + "/" + bar.toString();
        this.checkCommandsWithUriPath(pathHdfsSchema);
        InetSocketAddress httpAddress = cluster.getNameNode(0).getHttpAddress();
        String pathWebhdfsSchema = "webhdfs://" + httpAddress.getHostName() + ":" + httpAddress.getPort() + "/" + bar.toString();
        this.checkCommandsWithUriPath(pathWebhdfsSchema);
    }

    private void checkCommandsWithUriPath(String pathWithSchema) throws Exception {
        StoragePolicyAdmin admin = new StoragePolicyAdmin(conf);
        DFSTestUtil.toolRun((Tool)admin, "-setStoragePolicy -path " + pathWithSchema + " -policy WARM", 0, "Set storage policy WARM on " + pathWithSchema);
        BlockStoragePolicySuite suite = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy warm = suite.getPolicy("WARM");
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path " + pathWithSchema, 0, "The storage policy of " + pathWithSchema + ":\n" + warm);
        DFSTestUtil.toolRun((Tool)admin, "-unsetStoragePolicy -path " + pathWithSchema, 0, "Unset storage policy from " + pathWithSchema);
    }
}

