/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion.plexus;

import java.io.File;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.rat.config.exclusion.plexus.MatchPattern;

public final class MatchPatterns {
    private final MatchPattern[] patterns;

    private MatchPatterns(MatchPattern[] patterns) {
        this.patterns = patterns;
    }

    public String toString() {
        return this.source();
    }

    public String source() {
        ArrayList<String> sources = new ArrayList<String>();
        for (MatchPattern pattern : this.patterns) {
            sources.add(pattern.source());
        }
        return "[" + String.join((CharSequence)", ", sources) + "]";
    }

    public boolean matches(String name, boolean isCaseSensitive) {
        String[] tokenized = MatchPattern.tokenizePathToString(name, File.separator);
        return this.matches(name, tokenized, isCaseSensitive);
    }

    public boolean matches(String name, String[] tokenizedName, boolean isCaseSensitive) {
        char[][] tokenizedNameChar = new char[tokenizedName.length][];
        for (int i2 = 0; i2 < tokenizedName.length; ++i2) {
            tokenizedNameChar[i2] = tokenizedName[i2].toCharArray();
        }
        return this.matches(name, tokenizedNameChar, isCaseSensitive);
    }

    public boolean matches(String name, char[][] tokenizedNameChar, boolean isCaseSensitive) {
        for (MatchPattern pattern : this.patterns) {
            if (!pattern.matchPath(name, tokenizedNameChar, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public Predicate<String> asPredicate(boolean isCaseSensitive) {
        return name -> this.matches((String)name, isCaseSensitive);
    }

    public boolean matchesPatternStart(String name, boolean isCaseSensitive) {
        for (MatchPattern includesPattern : this.patterns) {
            if (!includesPattern.matchPatternStart(name, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public static MatchPatterns from(String ... sources) {
        int length = sources.length;
        MatchPattern[] result = new MatchPattern[length];
        for (int i2 = 0; i2 < length; ++i2) {
            result[i2] = MatchPattern.fromString(sources[i2]);
        }
        return new MatchPatterns(result);
    }

    public static MatchPatterns from(Iterable<String> strings) {
        return new MatchPatterns(MatchPatterns.getMatchPatterns(strings));
    }

    private static MatchPattern[] getMatchPatterns(Iterable<String> items) {
        ArrayList<MatchPattern> result = new ArrayList<MatchPattern>();
        for (String string : items) {
            result.add(MatchPattern.fromString(string));
        }
        return result.toArray(new MatchPattern[0]);
    }
}

