/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.api;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.rat.api.Document;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.tika.mime.MediaType;

public class MetaData {
    private final SortedSet<ILicense> matchedLicenses = new TreeSet<ILicense>();
    private final Set<String> approvedLicenses = new HashSet<String>();
    private Charset charset;
    private MediaType mediaType;
    private Document.Type documentType;
    private String sampleHeader;

    public Charset getCharset() {
        return this.charset == null ? Charset.defaultCharset() : this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public boolean detectedLicense() {
        return !this.matchedLicenses.isEmpty();
    }

    public void setApprovedLicenses(Set<ILicenseFamily> approvedLicenseFamilies) {
        this.licenses().filter(lic -> approvedLicenseFamilies.contains(lic.getLicenseFamily())).forEach(lic -> this.approvedLicenses.add(lic.getId()));
    }

    public Stream<ILicense> licenses() {
        return this.matchedLicenses.stream();
    }

    public Stream<ILicense> approvedLicenses() {
        return this.licenses().filter(this::isApproved);
    }

    public boolean isApproved(ILicense license) {
        return this.approvedLicenses.contains(license.getId());
    }

    public Stream<ILicense> unapprovedLicenses() {
        return this.licenses().filter(lic -> !this.isApproved((ILicense)lic));
    }

    public void setSampleHeader(String sampleHeader) {
        this.sampleHeader = sampleHeader;
    }

    public String getSampleHeader() {
        return this.sampleHeader;
    }

    public void setDocumentType(Document.Type type) {
        this.documentType = type;
    }

    public Document.Type getDocumentType() {
        return this.documentType;
    }

    public void reportOnLicense(ILicense license) {
        this.matchedLicenses.add(license);
    }

    public void removeLicenses(Predicate<ILicense> filter) {
        this.matchedLicenses.removeIf(filter);
    }

    public String toString() {
        return String.format("MetaData[%s license, %s approved]", this.matchedLicenses.size(), this.approvedLicenses.size());
    }
}

