/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BOMOutputStreamFilter
extends FilterOutputStream {
    private static final Log log = LogFactory.getLog(BOMOutputStreamFilter.class);
    int count = 0;
    int bomLength = 2;

    public BOMOutputStreamFilter(String encoding, OutputStream out) {
        super(out);
        if (encoding == null || encoding.equalsIgnoreCase("UTF-8")) {
            this.bomLength = 0;
        } else if (encoding.equalsIgnoreCase("UTF-16")) {
            this.bomLength = 2;
        } else {
            this.bomLength = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Don't know the BOM length for " + encoding + ". assuming zero."));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("encoding = " + encoding));
            log.debug((Object)("expected BOM length = " + this.bomLength));
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count >= this.bomLength) {
            this.out.write(b);
        } else if (b == -1 || b == -2) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping BOM character " + b + " at position " + this.count));
            }
        } else {
            this.out.write(b);
        }
        ++this.count;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (this.count < this.bomLength && len > 0) {
            this.write(b[off]);
            ++off;
            --len;
        }
        if (len > 0) {
            this.out.write(b, off, len);
            this.count += len;
        }
    }
}

