/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.xmlbeans;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.namespace.Constants;
import org.apache.axis2.util.SchemaUtil;
import org.apache.axis2.util.URLProcessor;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.xmlbeans.XSDConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.xmlbeans.BindingConfig;
import org.apache.xmlbeans.Filer;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CodeGenerationUtility {
    public static final String SCHEMA_FOLDER = "schemas";
    public static String MAPPINGS = "mappings";
    public static String MAPPING = "mapping";
    public static String MESSAGE = "message";
    public static String JAVA_NAME = "javaclass";
    public static final String MAPPING_FOLDER = "Mapping";
    public static final String MAPPER_FILE_NAME = "mapper";
    public static final String SCHEMA_PATH = "/org/apache/axis2/wsdl/codegen/schema/";
    private static final Log log = LogFactory.getLog(CodeGenerationUtility.class);
    boolean debug = false;

    public static TypeMapper processSchemas(List schemas, Element[] additionalSchemas, CodeGenConfiguration cgconfig, String typeSystemName) throws RuntimeException {
        try {
            int j;
            XmlOptions options;
            XmlSchema schema;
            int i;
            if (schemas == null || schemas.isEmpty()) {
                return new DefaultTypeMapper();
            }
            ArrayList<XmlSchema> completeSchemaList = new ArrayList<XmlSchema>();
            ArrayList<XmlObject> topLevelSchemaList = new ArrayList<XmlObject>();
            TypeMapper mapper = cgconfig.getTypeMapper();
            if (mapper == null) {
                mapper = new JavaTypeMapper();
            }
            mapper.setDefaultMappingName(XmlObject.class.getName());
            HashMap nameSpacesMap = new HashMap();
            List axisServices = cgconfig.getAxisServices();
            for (AxisService axisService : axisServices) {
                nameSpacesMap.putAll(axisService.getNamespaceMap());
            }
            for (i = 0; i < schemas.size(); ++i) {
                schema = (XmlSchema)schemas.get(i);
                options = new XmlOptions();
                options.setLoadAdditionalNamespaces(nameSpacesMap);
                XmlSchema[] allSchemas = SchemaUtil.getAllSchemas((XmlSchema)schema);
                for (int j2 = 0; j2 < allSchemas.length; ++j2) {
                    completeSchemaList.add(allSchemas[j2]);
                }
            }
            for (i = 0; i < schemas.size(); ++i) {
                schema = (XmlSchema)schemas.get(i);
                options = new XmlOptions();
                options.setLoadAdditionalNamespaces(nameSpacesMap);
                topLevelSchemaList.add(XmlObject.Factory.parse((String)CodeGenerationUtility.getSchemaAsString(schema), (XmlOptions)options));
            }
            XmlSchemaCollection extras = new XmlSchemaCollection();
            for (int i2 = 0; i2 < additionalSchemas.length; ++i2) {
                completeSchemaList.add(extras.read(additionalSchemas[i2]));
                topLevelSchemaList.add(XmlObject.Factory.parse((Node)additionalSchemas[i2], null));
            }
            Axis2EntityResolver er = new Axis2EntityResolver();
            er.setSchemas(completeSchemaList.toArray(new XmlSchema[completeSchemaList.size()]));
            er.setBaseUri(cgconfig.getBaseURI());
            String xsdConfigFile = (String)cgconfig.getProperties().get("xc");
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setEntityResolver((EntityResolver)er);
            if (null != cgconfig.getProperty((Object)"javaversion")) {
                xmlOptions.put((Object)"GENERATE_JAVA_VERSION", cgconfig.getProperty((Object)"javaversion"));
            }
            SchemaTypeSystem sts = XmlBeans.compileXmlBeans((String)typeSystemName, null, (XmlObject[])CodeGenerationUtility.convertToSchemaArray(topLevelSchemaList), (BindingConfig)new Axis2BindingConfig(cgconfig.getUri2PackageNameMap(), xsdConfigFile), (SchemaTypeLoader)XmlBeans.getContextTypeLoader(), (Filer)new Axis2Filer(cgconfig), (XmlOptions)xmlOptions);
            cgconfig.putProperty((Object)"base64map", (Object)CodeGenerationUtility.findBase64Types(sts));
            cgconfig.putProperty((Object)"plainbase64map", (Object)CodeGenerationUtility.findPlainBase64Types(sts));
            SchemaTypeSystem internal = XmlBeans.getBuiltinTypeSystem();
            SchemaType[] schemaTypes = internal.globalTypes();
            for (j = 0; j < schemaTypes.length; ++j) {
                mapper.addTypeMappingName(schemaTypes[j].getName(), schemaTypes[j].getFullJavaName());
            }
            schemaTypes = sts.documentTypes();
            for (j = 0; j < schemaTypes.length; ++j) {
                mapper.addTypeMappingName(schemaTypes[j].getDocumentElementName(), schemaTypes[j].getFullJavaName());
            }
            if (!cgconfig.isParametersWrapped()) {
                axisServices = cgconfig.getAxisServices();
                for (AxisService axisService : axisServices) {
                    Iterator operations = axisService.getOperations();
                    while (operations.hasNext()) {
                        SchemaType primitiveType;
                        String fullJaveName;
                        QName partQName;
                        SchemaProperty elementProperty;
                        int i3;
                        SchemaProperty[] elementProperties;
                        SchemaType sType;
                        SchemaGlobalElement xmlbeansElement;
                        AxisMessage message;
                        AxisOperation op = (AxisOperation)operations.next();
                        if (WSDLUtil.isInputPresentForMEP((String)op.getMessageExchangePattern()) && (message = op.getMessage("In")) != null && message.getParameter("UnWrapped") != null) {
                            xmlbeansElement = sts.findElement(message.getElementQName());
                            sType = xmlbeansElement.getType();
                            elementProperties = sType.getElementProperties();
                            for (i3 = 0; i3 < elementProperties.length; ++i3) {
                                elementProperty = elementProperties[i3];
                                partQName = WSDLUtil.getPartQName((String)op.getName().getLocalPart(), (String)"_input", (String)elementProperty.getName().getLocalPart());
                                fullJaveName = elementProperty.getType().getFullJavaName();
                                if (elementProperty.extendsJavaArray()) {
                                    fullJaveName = fullJaveName.concat("[]");
                                }
                                mapper.addTypeMappingName(partQName, fullJaveName);
                                primitiveType = elementProperty.getType().getPrimitiveType();
                                if (primitiveType != null) {
                                    mapper.addTypeMappingStatus(partQName, (Object)Boolean.TRUE);
                                }
                                if (!elementProperty.extendsJavaArray()) continue;
                                mapper.addTypeMappingStatus(partQName, (Object)"arrayType");
                            }
                        }
                        if (!WSDLUtil.isOutputPresentForMEP((String)op.getMessageExchangePattern()) || (message = op.getMessage("Out")) == null || message.getParameter("UnWrapped") == null) continue;
                        xmlbeansElement = sts.findElement(message.getElementQName());
                        sType = xmlbeansElement.getType();
                        elementProperties = sType.getElementProperties();
                        for (i3 = 0; i3 < elementProperties.length; ++i3) {
                            elementProperty = elementProperties[i3];
                            partQName = WSDLUtil.getPartQName((String)op.getName().getLocalPart(), (String)"_output", (String)elementProperty.getName().getLocalPart());
                            fullJaveName = elementProperty.getType().getFullJavaName();
                            if (elementProperty.extendsJavaArray()) {
                                fullJaveName = fullJaveName.concat("[]");
                            }
                            mapper.addTypeMappingName(partQName, fullJaveName);
                            primitiveType = elementProperty.getType().getPrimitiveType();
                            if (primitiveType != null) {
                                mapper.addTypeMappingStatus(partQName, (Object)Boolean.TRUE);
                            }
                            if (!elementProperty.extendsJavaArray()) continue;
                            mapper.addTypeMappingStatus(partQName, (Object)"arrayType");
                        }
                    }
                }
            }
            return mapper;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List findBase64Types(SchemaTypeSystem sts) {
        ArrayList<SchemaType> allSeenTypes = new ArrayList<SchemaType>();
        ArrayList<QName> base64ElementQNamesList = new ArrayList<QName>();
        allSeenTypes.addAll(Arrays.asList(sts.documentTypes()));
        allSeenTypes.addAll(Arrays.asList(sts.globalTypes()));
        for (int i = 0; i < allSeenTypes.size(); ++i) {
            SchemaType sType = (SchemaType)allSeenTypes.get(i);
            if (sType.getContentType() == 2 && sType.getPrimitiveType() != null && Constants.BASE_64_CONTENT_QNAME.equals(sType.getPrimitiveType().getName())) {
                SchemaType outerType = sType.getOuterType();
                SchemaProperty[] properties = sType.getProperties();
                for (int j = 0; j < properties.length; ++j) {
                    if (!Constants.XMIME_CONTENT_TYPE_QNAME.equals(properties[j].getName())) continue;
                    if (!outerType.isDocumentType()) break;
                    base64ElementQNamesList.add(outerType.getDocumentElementName());
                    break;
                }
            }
            allSeenTypes.addAll(Arrays.asList(sType.getAnonymousTypes()));
        }
        return base64ElementQNamesList;
    }

    private static List findPlainBase64Types(SchemaTypeSystem sts) {
        ArrayList<SchemaType> allSeenTypes = new ArrayList<SchemaType>();
        allSeenTypes.addAll(Arrays.asList(sts.documentTypes()));
        allSeenTypes.addAll(Arrays.asList(sts.globalTypes()));
        ArrayList base64Types = new ArrayList();
        for (SchemaType stype : allSeenTypes) {
            CodeGenerationUtility.findPlainBase64Types(stype, base64Types, new ArrayList());
        }
        return base64Types;
    }

    private static void findPlainBase64Types(SchemaType stype, ArrayList base64Types, ArrayList processedTypes) {
        SchemaProperty[] elementProperties = stype.getElementProperties();
        for (int i = 0; i < elementProperties.length; ++i) {
            SchemaType schemaType = elementProperties[i].getType();
            QName name = elementProperties[i].getName();
            if (base64Types.contains(name) || processedTypes.contains(schemaType.getName())) continue;
            processedTypes.add(stype.getName());
            if (schemaType.isPrimitiveType()) {
                SchemaType primitiveType = schemaType.getPrimitiveType();
                if (!Constants.BASE_64_CONTENT_QNAME.equals(primitiveType.getName())) continue;
                base64Types.add(name);
                continue;
            }
            CodeGenerationUtility.findPlainBase64Types(schemaType, base64Types, processedTypes);
        }
    }

    private static String getSchemaAsString(XmlSchema schema) throws IOException {
        StringWriter writer = new StringWriter();
        schema.write((Writer)writer);
        return writer.toString();
    }

    private static SchemaDocument.Schema[] convertToSchemaArray(List vec) {
        SchemaDocument[] schemaDocuments = vec.toArray(new SchemaDocument[vec.size()]);
        Vector<SchemaDocument.Schema> uniqueSchemas = new Vector<SchemaDocument.Schema>(schemaDocuments.length);
        Vector<String> uniqueSchemaTns = new Vector<String>(schemaDocuments.length);
        for (int i = 0; i < schemaDocuments.length; ++i) {
            SchemaDocument.Schema s = schemaDocuments[i].getSchema();
            if (!uniqueSchemaTns.contains(s.getTargetNamespace())) {
                uniqueSchemas.add(s);
                uniqueSchemaTns.add(s.getTargetNamespace());
                continue;
            }
            if (s.getTargetNamespace() != null) continue;
            uniqueSchemas.add(s);
        }
        return uniqueSchemas.toArray(new SchemaDocument.Schema[uniqueSchemas.size()]);
    }

    private static class Axis2EntityResolver
    implements EntityResolver {
        private XmlSchema[] schemas;
        private String baseUri;

        private Axis2EntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.startsWith("project://local/")) {
                systemId = systemId.substring("project://local/".length());
            }
            if (!systemId.startsWith("http://")) {
                StringTokenizer pathElements = new StringTokenizer(systemId, "/");
                Stack<String> pathElementStack = new Stack<String>();
                while (pathElements.hasMoreTokens()) {
                    String pathElement = pathElements.nextToken();
                    if (".".equals(pathElement)) continue;
                    if ("..".equals(pathElement)) {
                        if (pathElementStack.isEmpty()) continue;
                        pathElementStack.pop();
                        continue;
                    }
                    pathElementStack.push(pathElement);
                }
                StringBuffer pathBuilder = new StringBuffer();
                Iterator iter = pathElementStack.iterator();
                while (iter.hasNext()) {
                    pathBuilder.append(File.separator + iter.next());
                }
                systemId = pathBuilder.toString().substring(1);
            }
            log.info((Object)("Resolving schema with publicId [" + publicId + "] and systemId [" + systemId + "]"));
            try {
                XmlSchema schema;
                int i;
                for (i = 0; i < this.schemas.length; ++i) {
                    String systemIDFinalPath;
                    schema = this.schemas[i];
                    if (schema.getSourceURI() == null || !schema.getSourceURI().endsWith(systemId.replaceAll("\\\\", "/")) || schema.getSourceURI().indexOf("/") == -1 && !(systemIDFinalPath = systemId.substring(systemId.indexOf("/") + 1)).equals(schema.getSourceURI())) continue;
                    String path = schema.getSourceURI();
                    File f = this.getFileFromURI(path);
                    if (f.exists()) {
                        InputSource source = new InputSource();
                        source.setSystemId(schema.getSourceURI());
                        return source;
                    }
                    return new InputSource(this.getSchemaAsInputStream(this.schemas[i]));
                }
                for (i = 0; i < this.schemas.length; ++i) {
                    schema = this.schemas[i];
                    if (schema.getTargetNamespace() == null || !schema.getTargetNamespace().equals(publicId)) continue;
                    return new InputSource(this.getSchemaAsInputStream(this.schemas[i]));
                }
                if (systemId.indexOf(58) == -1) {
                    this.baseUri = this.baseUri == null ? "file:///" : this.baseUri;
                    URL url = new URL(this.baseUri + systemId);
                    InputSource source = new InputSource();
                    source.setSystemId(url.toString());
                    return source;
                }
                return XMLUtils.getEmptyInputSource();
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        private File getFileFromURI(String path) {
            if (path.startsWith("file:///")) {
                path = path.substring(8);
            } else if (path.startsWith("file://")) {
                path = path.substring(7);
            } else if (path.startsWith("file:/")) {
                path = path.substring(6);
            }
            return new File(path);
        }

        public XmlSchema[] getSchemas() {
            return this.schemas;
        }

        public void setSchemas(XmlSchema[] schemas) {
            this.schemas = schemas;
        }

        public String getBaseUri() {
            return this.baseUri;
        }

        public void setBaseUri(String baseUri) {
            this.baseUri = baseUri;
        }

        private InputStream getSchemaAsInputStream(XmlSchema schema) throws UnsupportedEncodingException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            schema.write((OutputStream)baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
    }

    private static class Axis2BindingConfig
    extends BindingConfig {
        private Map uri2packageMappings = null;
        private XSDConfig xsdConfig = null;

        public Axis2BindingConfig(Map uri2packageMappings, String xsdConfigfile) {
            this.uri2packageMappings = uri2packageMappings;
            if (this.uri2packageMappings == null) {
                this.uri2packageMappings = new HashMap();
            }
            if (xsdConfigfile != null) {
                this.xsdConfig = new XSDConfig(xsdConfigfile);
            }
        }

        public String lookupPackageForNamespace(String uri) {
            if (this.xsdConfig != null && this.xsdConfig.hasNamespaceToJavaPackageMappings) {
                log.debug((Object)("RETURNING " + uri + " = " + this.xsdConfig.getNamespacesToJavaPackages().get(uri)));
                return (String)this.xsdConfig.getNamespacesToJavaPackages().get(uri);
            }
            if (this.uri2packageMappings.containsKey(uri)) {
                return (String)this.uri2packageMappings.get(uri);
            }
            return URLProcessor.makePackageName((String)uri);
        }

        public String lookupJavanameForQName(QName qname) {
            if (this.xsdConfig != null) {
                String key = qname.getNamespaceURI() + ":" + qname.getLocalPart();
                if (this.xsdConfig.getSchemaTypesToJavaNames().containsKey(key)) {
                    log.debug((Object)("RETURNING " + qname.getLocalPart() + " = " + this.xsdConfig.getSchemaTypesToJavaNames().get(key)));
                    return (String)this.xsdConfig.getSchemaTypesToJavaNames().get(key);
                }
                return null;
            }
            return super.lookupJavanameForQName(qname);
        }
    }

    private static class Axis2Filer
    implements Filer {
        private File location;
        private boolean flatten = false;
        private String resourceDirName;
        private String srcDirName;
        private static final String JAVA_FILE_EXTENSION = ".java";

        private Axis2Filer(CodeGenConfiguration config) {
            this.location = config.getOutputLocation();
            this.flatten = config.isFlattenFiles();
            this.resourceDirName = config.getResourceLocation();
            this.srcDirName = config.getSourceLocation();
        }

        public OutputStream createBinaryFile(String typename) throws IOException {
            File resourcesDirectory;
            File file = resourcesDirectory = this.flatten ? this.location : new File(this.location, this.resourceDirName);
            if (!resourcesDirectory.exists()) {
                resourcesDirectory.mkdirs();
            }
            File file2 = new File(resourcesDirectory, typename);
            file2.getParentFile().mkdirs();
            file2.createNewFile();
            return new FileOutputStream(file2);
        }

        public Writer createSourceFile(String typename) throws IOException {
            File outputDir;
            typename = typename.replace('.', File.separatorChar);
            File file = outputDir = this.flatten ? this.location : new File(this.location, this.srcDirName);
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            File file2 = new File(outputDir, typename + JAVA_FILE_EXTENSION);
            file2.getParentFile().mkdirs();
            file2.createNewFile();
            return new FileWriter(file2);
        }
    }
}

