/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.function.Function;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.MetadataUtil;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.hyracks.algebricks.common.utils.Triple;

public enum DependencyKind {
    DATASET(dependency -> DatasetUtil.getFullyQualifiedDisplayName((DataverseName)dependency.first, (String)dependency.second)),
    FUNCTION(dependency -> new FunctionSignature((DataverseName)dependency.first, (String)dependency.second, Integer.parseInt((String)dependency.third)).toString()),
    TYPE(dependency -> TypeUtil.getFullyQualifiedDisplayName((DataverseName)dependency.first, (String)dependency.second)),
    SYNONYM(dependency -> MetadataUtil.getFullyQualifiedDisplayName((DataverseName)dependency.first, (String)dependency.second));

    private final Function<Triple<DataverseName, String, String>, String> dependencyDisplayNameAccessor;

    private DependencyKind(Function<Triple<DataverseName, String, String>, String> dependencyDisplayNameAccessor) {
        this.dependencyDisplayNameAccessor = dependencyDisplayNameAccessor;
    }

    public String getDependencyDisplayName(Triple<DataverseName, String, String> dependency) {
        return this.dependencyDisplayNameAccessor.apply(dependency);
    }

    public String toString() {
        return this == DATASET ? IdentifierUtil.dataset() + " (or view)" : this.name().toLowerCase();
    }
}

