/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.impls.AbstractSearchPredicate;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.EmptyComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.FlushOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexReplicationJob;
import org.apache.hyracks.storage.am.lsm.common.impls.LoadOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.NoOpIoOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.TracedIOOperation;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLSMIndex
implements ILSMIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ILSMHarness lsmHarness;
    protected final IIOManager ioManager;
    protected final ILSMIOOperationCallback ioOpCallback;
    protected final List<ILSMMemoryComponent> memoryComponents;
    protected final List<IVirtualBufferCache> virtualBufferCaches;
    protected AtomicInteger currentMutableComponentId;
    protected final IBufferCache diskBufferCache;
    protected final ILSMIndexFileManager fileManager;
    protected final List<ILSMDiskComponent> diskComponents;
    protected final List<ILSMDiskComponent> inactiveDiskComponents;
    protected final List<ILSMMemoryComponent> inactiveMemoryComponents;
    protected final double bloomFilterFalsePositiveRate;
    protected final IComponentFilterHelper filterHelper;
    protected final ILSMComponentFilterFrameFactory filterFrameFactory;
    protected final LSMComponentFilterManager filterManager;
    protected final int[] treeFields;
    protected final int[] filterFields;
    protected final boolean durable;
    protected boolean isActive;
    protected volatile boolean isDeactivating = false;
    protected final AtomicBoolean[] flushRequests;
    protected volatile boolean memoryComponentsAllocated = false;
    protected ITracer tracer;
    protected final ILSMDiskComponentFactory componentFactory;
    protected final ILSMDiskComponentFactory bulkLoadComponentFactory;
    protected final ILSMPageWriteCallbackFactory pageWriteCallbackFactory;
    private int numScheduledFlushes = 0;

    public AbstractLSMIndex(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, ILSMDiskComponentFactory componentFactory, ILSMDiskComponentFactory bulkLoadComponentFactory, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, int[] filterFields, boolean durable, IComponentFilterHelper filterHelper, int[] treeFields, ITracer tracer) throws HyracksDataException {
        this.ioManager = ioManager;
        this.virtualBufferCaches = virtualBufferCaches;
        this.diskBufferCache = diskBufferCache;
        this.fileManager = fileManager;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
        this.ioOpCallback = ioOpCallbackFactory.createIoOpCallback(this);
        this.pageWriteCallbackFactory = pageWriteCallbackFactory;
        this.componentFactory = componentFactory;
        this.bulkLoadComponentFactory = bulkLoadComponentFactory;
        this.filterHelper = filterHelper;
        this.filterFrameFactory = filterFrameFactory;
        this.filterManager = filterManager;
        this.treeFields = treeFields;
        this.filterFields = filterFields;
        this.inactiveDiskComponents = new ArrayList<ILSMDiskComponent>();
        this.inactiveMemoryComponents = new ArrayList<ILSMMemoryComponent>();
        this.durable = durable;
        this.tracer = tracer;
        fileManager.initLastUsedSeq(this.ioOpCallback.getLastValidSequence());
        this.lsmHarness = new LSMHarness(this, ioScheduler, mergePolicy, opTracker, diskBufferCache.isReplicationEnabled(), tracer);
        this.isActive = false;
        this.diskComponents = new ArrayList<ILSMDiskComponent>();
        this.memoryComponents = new ArrayList<ILSMMemoryComponent>();
        this.currentMutableComponentId = new AtomicInteger(ioOpCallbackFactory.getCurrentMemoryComponentIndex());
        this.flushRequests = new AtomicBoolean[virtualBufferCaches.size()];
        for (int i = 0; i < virtualBufferCaches.size(); ++i) {
            this.flushRequests[i] = new AtomicBoolean();
        }
    }

    public AbstractLSMIndex(IIOManager ioManager, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, ILSMDiskComponentFactory componentFactory, ILSMDiskComponentFactory bulkLoadComponentFactory, boolean durable, ITracer tracer) throws HyracksDataException {
        this.ioManager = ioManager;
        this.diskBufferCache = diskBufferCache;
        this.fileManager = fileManager;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
        this.ioOpCallback = ioOpCallbackFactory.createIoOpCallback(this);
        this.pageWriteCallbackFactory = pageWriteCallbackFactory;
        this.componentFactory = componentFactory;
        this.bulkLoadComponentFactory = bulkLoadComponentFactory;
        this.durable = durable;
        this.tracer = tracer;
        this.lsmHarness = new ExternalIndexHarness(this, ioScheduler, mergePolicy, opTracker, diskBufferCache.isReplicationEnabled());
        this.isActive = false;
        this.diskComponents = new ArrayList<ILSMDiskComponent>();
        this.inactiveDiskComponents = new ArrayList<ILSMDiskComponent>();
        this.inactiveMemoryComponents = new ArrayList<ILSMMemoryComponent>();
        this.virtualBufferCaches = null;
        this.memoryComponents = null;
        this.currentMutableComponentId = null;
        this.flushRequests = null;
        this.filterHelper = null;
        this.filterFrameFactory = null;
        this.filterManager = null;
        this.treeFields = null;
        this.filterFields = null;
        fileManager.initLastUsedSeq(this.ioOpCallback.getLastValidSequence());
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CREATE_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.fileManager.createDirs();
        this.diskComponents.clear();
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_ACTIVATE_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.loadDiskComponents();
        this.isActive = true;
    }

    private void loadDiskComponents() throws HyracksDataException {
        this.diskComponents.clear();
        List<LSMComponentFileReferences> validFileReferences = this.fileManager.cleanupAndGetValidFiles();
        for (LSMComponentFileReferences lsmComponentFileReferences : validFileReferences) {
            ILSMDiskComponent component = this.createDiskComponent(this.componentFactory, lsmComponentFileReferences.getInsertIndexFileReference(), lsmComponentFileReferences.getDeleteIndexFileReference(), lsmComponentFileReferences.getBloomFilterFileReference(), false);
            this.diskComponents.add(component);
        }
    }

    public final synchronized void deactivate() throws HyracksDataException {
        this.deactivate(true);
    }

    @Override
    public synchronized void deactivate(boolean flush) throws HyracksDataException {
        if (!this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_DEACTIVATE_INACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.isDeactivating = true;
        try {
            LOGGER.log(Level.INFO, "Deactivating the index: {}. STARTED", (Object)this);
            if (flush && this.memoryComponentsAllocated) {
                try {
                    this.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE).scheduleFlush().sync();
                }
                catch (InterruptedException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                LOGGER.log(Level.INFO, "Deactivating the index: {}. Flushed", (Object)this);
            }
            LOGGER.log(Level.INFO, "Deactivating the disk components of: {}", (Object)this);
            this.deactivateDiskComponents();
            LOGGER.log(Level.INFO, "Deallocating memory components of: {}", (Object)this);
            this.deallocateMemoryComponents();
            this.isActive = false;
            LOGGER.log(Level.INFO, "Deactivating the index: {}. COMPLETED", (Object)this);
        }
        finally {
            this.isDeactivating = false;
        }
    }

    private void deactivateDiskComponents() throws HyracksDataException {
        for (ILSMDiskComponent c : this.diskComponents) {
            c.deactivateAndPurge();
        }
    }

    private void deallocateMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMMemoryComponent c : this.memoryComponents) {
                c.deallocate();
            }
            this.memoryComponentsAllocated = false;
        }
    }

    public synchronized void destroy() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_DESTROY_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.destroyDiskComponents();
        this.fileManager.deleteDirs();
    }

    private void destroyDiskComponents() throws HyracksDataException {
        for (ILSMDiskComponent c : this.diskComponents) {
            c.destroy();
        }
    }

    public synchronized void clear() throws HyracksDataException {
        if (!this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CLEAR_INACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.resetMemoryComponents();
        this.deactivateAndDestroyDiskComponents();
    }

    private void deactivateAndDestroyDiskComponents() throws HyracksDataException {
        for (ILSMDiskComponent c : this.diskComponents) {
            c.deactivateAndDestroy();
        }
        this.diskComponents.clear();
    }

    private void resetMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated && this.memoryComponents != null) {
            for (ILSMMemoryComponent c : this.memoryComponents) {
                c.cleanup();
                c.reset();
            }
        }
        this.numScheduledFlushes = 0;
        this.currentMutableComponentId.set(0);
    }

    public void purge() throws HyracksDataException {
    }

    @Override
    public void getOperationalComponents(ILSMIndexOperationContext ctx) throws HyracksDataException {
        List<ILSMComponent> operationalComponents = ctx.getComponentHolder();
        int cmc = this.currentMutableComponentId.get();
        ctx.setCurrentMutableComponentId(cmc);
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case UPDATE: 
            case PHYSICALDELETE: 
            case DELETE_COMPONENTS: 
            case DELETE: 
            case UPSERT: {
                operationalComponents.add(this.memoryComponents.get(cmc));
                break;
            }
            case INSERT: {
                this.addOperationalMemoryComponents(operationalComponents, true);
                operationalComponents.addAll(this.diskComponents);
                break;
            }
            case SEARCH: {
                if (this.memoryComponentsAllocated) {
                    this.addOperationalMemoryComponents(operationalComponents, false);
                }
                if (this.filterManager != null) {
                    for (int i = 0; i < this.diskComponents.size(); ++i) {
                        ILSMComponent c = this.diskComponents.get(i);
                        if (!c.getLSMComponentFilter().satisfy(((AbstractSearchPredicate)ctx.getSearchPredicate()).getMinFilterTuple(), ((AbstractSearchPredicate)ctx.getSearchPredicate()).getMaxFilterTuple(), ctx.getFilterCmp())) continue;
                        operationalComponents.add(c);
                    }
                    break;
                }
                operationalComponents.addAll(this.diskComponents);
                break;
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            case DISK_COMPONENT_SCAN: {
                operationalComponents.addAll(this.diskComponents);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    @Override
    public void scanDiskComponents(ILSMIndexOperationContext ctx, IIndexCursor cursor) throws HyracksDataException {
        throw HyracksDataException.create((ErrorCode)ErrorCode.DISK_COMPONENT_SCAN_NOT_ALLOWED_FOR_SECONDARY_INDEX, (Serializable[])new Serializable[0]);
    }

    @Override
    public ILSMIOOperation createFlushOperation(ILSMIndexOperationContext ctx) throws HyracksDataException {
        ILSMMemoryComponent flushingComponent = this.getCurrentMemoryComponent();
        if (flushingComponent.getWriterCount() > 0) {
            throw new IllegalStateException("createFlushOperation is called on a component with writers: " + flushingComponent);
        }
        ILSMIOOperation flushOp = TracedIOOperation.wrap(this.createFlushOperation(this.createOpContext((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE), this.fileManager.getRelFlushFileReference(), this.ioOpCallback), this.tracer);
        flushingComponent.schedule(ILSMIOOperation.LSMIOOperationType.FLUSH);
        ++this.numScheduledFlushes;
        this.changeFlushStatusForCurrentMutableCompoent(false);
        this.changeMutableComponent();
        ILSMIndexAccessor accessor = flushOp.getAccessor();
        ILSMIndexOperationContext flushCtx = accessor.getOpContext();
        flushCtx.setOperation(ctx.getOperation());
        flushCtx.getComponentHolder().add(flushingComponent);
        flushCtx.setIoOperation(flushOp);
        AbstractLSMIndex.propagateMap(ctx, flushCtx);
        this.ioOpCallback.scheduled(flushOp);
        return flushOp;
    }

    @Override
    public ILSMIOOperation createMergeOperation(ILSMIndexOperationContext ctx) throws HyracksDataException {
        List<ILSMDiskComponent> mergingComponents = ctx.getComponentsToBeMerged();
        if (this.isDeactivating || mergingComponents.size() < 2 && ctx.getOperation() != IndexOperation.DELETE_COMPONENTS) {
            return NoOpIoOperation.INSTANCE;
        }
        for (int i = 0; i < mergingComponents.size(); ++i) {
            if (mergingComponents.get(i).getState() != ILSMComponent.ComponentState.READABLE_MERGING) continue;
            return NoOpIoOperation.INSTANCE;
        }
        AbstractLSMIndexOperationContext mergeCtx = this.createOpContext((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        mergeCtx.setOperation(ctx.getOperation());
        mergeCtx.getComponentHolder().addAll(mergingComponents);
        AbstractLSMIndex.propagateMap(ctx, mergeCtx);
        mergingComponents.stream().forEach(mergeCtx.getComponentsToBeMerged()::add);
        ILSMDiskComponent lastComponent = mergingComponents.get(0);
        ILSMDiskComponent firstComponent = mergingComponents.get(mergingComponents.size() - 1);
        LSMComponentFileReferences mergeFileRefs = this.getMergeFileReferences(firstComponent, lastComponent);
        ILSMIOOperation mergeOp = TracedIOOperation.wrap(this.createMergeOperation(mergeCtx, mergeFileRefs, this.ioOpCallback), this.tracer);
        mergeCtx.setIoOperation(mergeOp);
        for (int i = 0; i < mergingComponents.size(); ++i) {
            mergingComponents.get(i).schedule(ILSMIOOperation.LSMIOOperationType.MERGE);
        }
        this.ioOpCallback.scheduled(mergeOp);
        return mergeOp;
    }

    private static void propagateMap(ILSMIndexOperationContext src, ILSMIndexOperationContext destination) {
        Map<String, Object> map = src.getParameters();
        if (map != null && !map.isEmpty()) {
            destination.setParameters(new HashMap<String, Object>(map));
        }
    }

    private void addOperationalMemoryComponents(List<ILSMComponent> operationalComponents, boolean modification) {
        if (this.numScheduledFlushes < this.memoryComponents.size()) {
            ILSMMemoryComponent c = this.memoryComponents.get(this.currentMutableComponentId.get());
            if (modification || c.isReadable()) {
                operationalComponents.add(c);
            }
        }
        if (modification && this.numScheduledFlushes >= this.memoryComponents.size()) {
            operationalComponents.add(this.memoryComponents.get(0));
            return;
        }
        this.addImmutableMemoryComponents(operationalComponents);
    }

    private void addImmutableMemoryComponents(List<ILSMComponent> operationalComponents) {
        int cmc = this.currentMutableComponentId.get();
        int numImmutableMemoryComponents = Integer.min(this.numScheduledFlushes, this.memoryComponents.size());
        int next = this.numScheduledFlushes < this.memoryComponents.size() ? cmc : this.getNextToBeFlushed();
        for (int i = 0; i < numImmutableMemoryComponents; ++i) {
            ILSMMemoryComponent c;
            if (--next < 0) {
                next = this.memoryComponents.size() - 1;
            }
            if (!(c = this.memoryComponents.get(next)).isReadable()) continue;
            operationalComponents.add(c);
        }
    }

    private ILSMMemoryComponent getOldestReadableMemoryComponent() {
        ILSMOperationTracker iLSMOperationTracker = this.getOperationTracker();
        synchronized (iLSMOperationTracker) {
            int i;
            int cmc = this.currentMutableComponentId.get();
            int numImmutableMemoryComponents = Integer.min(this.numScheduledFlushes, this.memoryComponents.size());
            int next = this.numScheduledFlushes < this.memoryComponents.size() ? cmc : this.getNextToBeFlushed();
            for (i = 0; i < numImmutableMemoryComponents; ++i) {
                if (--next >= 0) continue;
                next = this.memoryComponents.size() - 1;
            }
            for (i = 0; i < numImmutableMemoryComponents; ++i) {
                if (this.memoryComponents.get(next).isReadable()) {
                    return this.memoryComponents.get(next);
                }
                if (++next != this.memoryComponents.size()) continue;
                next = 0;
            }
            throw new IllegalStateException("Couldn't find any readable component");
        }
    }

    private int getNextToBeFlushed() {
        int diff = this.numScheduledFlushes % this.memoryComponents.size();
        int cmc = this.currentMutableComponentId.get() - diff;
        return cmc < 0 ? this.memoryComponents.size() + cmc : cmc;
    }

    public final IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, IPageWriteCallback callback) throws HyracksDataException {
        return this.createBulkLoader(fillLevel, verifyInput, numElementsHint, checkIfEmptyIndex, Collections.emptyMap());
    }

    @Override
    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, Map<String, Object> parameters) throws HyracksDataException {
        if (checkIfEmptyIndex && !this.isEmptyIndex()) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.LOAD_NON_EMPTY_INDEX, (Serializable[])new Serializable[0]);
        }
        return this.createBulkLoader(fillFactor, verifyInput, numElementsHint, parameters);
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, Map<String, Object> parameters) throws HyracksDataException {
        AbstractLSMIndexOperationContext opCtx = this.createOpContext((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        opCtx.setParameters(parameters);
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        LoadOperation loadOp = new LoadOperation(componentFileRefs, this.ioOpCallback, this.getIndexIdentifier(), parameters);
        loadOp.setNewComponent(this.createDiskComponent(this.bulkLoadComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true));
        this.ioOpCallback.scheduled(loadOp);
        opCtx.setIoOperation(loadOp);
        return new LSMIndexDiskComponentBulkLoader(this, opCtx, fillLevel, verifyInput, numElementsHint);
    }

    @Override
    public ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException {
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        return this.createDiskComponent(this.bulkLoadComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
    }

    protected ILSMDiskComponent createDiskComponent(ILSMDiskComponentFactory factory, FileReference insertFileReference, FileReference deleteIndexFileReference, FileReference bloomFilterFileRef, boolean createComponent) throws HyracksDataException {
        ILSMDiskComponent component = factory.createComponent(this, new LSMComponentFileReferences(insertFileReference, deleteIndexFileReference, bloomFilterFileRef));
        component.activate(createComponent);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void allocateMemoryComponents() throws HyracksDataException {
        ILSMMemoryComponent c;
        int i;
        if (!this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_ALLOCATE_MEMORY_FOR_INACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        if (this.memoryComponentsAllocated || this.memoryComponents == null) {
            return;
        }
        boolean allocated = false;
        try {
            for (i = 0; i < this.memoryComponents.size(); ++i) {
                allocated = false;
                c = this.memoryComponents.get(i);
                c.allocate();
                allocated = true;
                this.ioOpCallback.allocated(c);
            }
        }
        finally {
            if (i < this.memoryComponents.size()) {
                if (allocated) {
                    c = this.memoryComponents.get(i);
                    c.deallocate();
                }
                for (int j = i - 1; j >= 0; --j) {
                    ILSMMemoryComponent c2 = this.memoryComponents.get(j);
                    c2.deallocate();
                }
            }
        }
        this.memoryComponentsAllocated = true;
    }

    @Override
    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        if (c != EmptyComponent.INSTANCE) {
            this.diskComponents.add(0, c);
        }
        this.validateComponentIds();
    }

    @Override
    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex = this.diskComponents.indexOf(mergedComponents.get(0));
        this.diskComponents.removeAll(mergedComponents);
        if (newComponent != EmptyComponent.INSTANCE) {
            this.diskComponents.add(swapIndex, newComponent);
        }
        this.validateComponentIds();
    }

    private void validateComponentIds() throws HyracksDataException {
        for (int i = 0; i < this.diskComponents.size() - 1; ++i) {
            ILSMComponentId id2;
            ILSMComponentId id1 = this.diskComponents.get(i).getId();
            ILSMComponentId.IdCompareResult cmp = id1.compareTo(id2 = this.diskComponents.get(i + 1).getId());
            if (cmp == ILSMComponentId.IdCompareResult.UNKNOWN || cmp == ILSMComponentId.IdCompareResult.GREATER_THAN) continue;
            throw new IllegalStateException("found non-decreasing component ids (" + id1 + " -> " + id2 + ") on index " + this);
        }
    }

    @Override
    public void changeMutableComponent() {
        this.currentMutableComponentId.set((this.currentMutableComponentId.get() + 1) % this.memoryComponents.size());
    }

    @Override
    public List<ILSMDiskComponent> getDiskComponents() {
        return this.diskComponents;
    }

    @Override
    public void changeFlushStatusForCurrentMutableCompoent(boolean needsFlush) {
        this.flushRequests[this.currentMutableComponentId.get()].set(needsFlush);
    }

    @Override
    public boolean hasFlushRequestForCurrentMutableComponent() {
        return this.flushRequests[this.currentMutableComponentId.get()].get();
    }

    @Override
    public ILSMOperationTracker getOperationTracker() {
        return this.lsmHarness.getOperationTracker();
    }

    @Override
    public ILSMIOOperationCallback getIOOperationCallback() {
        return this.ioOpCallback;
    }

    public IBufferCache getBufferCache() {
        return this.diskBufferCache;
    }

    public boolean isEmptyIndex() {
        boolean isModified = false;
        for (ILSMComponent iLSMComponent : this.memoryComponents) {
            AbstractLSMMemoryComponent mutableComponent = (AbstractLSMMemoryComponent)iLSMComponent;
            if (!mutableComponent.isModified()) continue;
            isModified = true;
            break;
        }
        return this.diskComponents.isEmpty() && !isModified;
    }

    public final String toString() {
        return "{\"class\" : \"" + this.getClass().getSimpleName() + "\", \"dir\" : \"" + this.fileManager.getBaseDir() + "\", \"memory\" : " + (this.memoryComponents == null ? Integer.valueOf(0) : this.memoryComponents) + ", \"disk\" : " + this.diskComponents.size() + ", \"num-scheduled-flushes\":" + this.numScheduledFlushes + ", \"current-memory-component\":" + this.currentMutableComponentId.get() + "}";
    }

    @Override
    public final int getNumberOfAllMemoryComponents() {
        return this.virtualBufferCaches == null ? 0 : this.virtualBufferCaches.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrentMutableComponentEmpty() throws HyracksDataException {
        ILSMOperationTracker iLSMOperationTracker = this.getOperationTracker();
        synchronized (iLSMOperationTracker) {
            ILSMMemoryComponent cmc = this.getCurrentMemoryComponent();
            ILSMComponent.ComponentState state = cmc.getState();
            return state == ILSMComponent.ComponentState.READABLE_UNWRITABLE_FLUSHING || state == ILSMComponent.ComponentState.INACTIVE || state == ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE || !cmc.isModified();
        }
    }

    @Override
    public List<ILSMDiskComponent> getInactiveDiskComponents() {
        return this.inactiveDiskComponents;
    }

    @Override
    public void addInactiveDiskComponent(ILSMDiskComponent diskComponent) {
        this.inactiveDiskComponents.add(diskComponent);
    }

    @Override
    public List<ILSMMemoryComponent> getInactiveMemoryComponents() {
        return this.inactiveMemoryComponents;
    }

    @Override
    public void addInactiveMemoryComponent(ILSMMemoryComponent memoryComponent) {
        this.inactiveMemoryComponents.add(memoryComponent);
    }

    @Override
    public void scheduleReplication(ILSMIndexOperationContext ctx, List<ILSMDiskComponent> lsmComponents, IReplicationJob.ReplicationOperation operation, LSMOperationType opType) throws HyracksDataException {
        HashSet<String> componentFiles = new HashSet<String>();
        for (ILSMDiskComponent lsmComponent : lsmComponents) {
            componentFiles.addAll(lsmComponent.getLSMComponentPhysicalFiles());
        }
        IReplicationJob.ReplicationExecutionType executionType = opType == LSMOperationType.LOAD ? IReplicationJob.ReplicationExecutionType.SYNC : IReplicationJob.ReplicationExecutionType.ASYNC;
        LSMIndexReplicationJob job = new LSMIndexReplicationJob(this, ctx, componentFiles, operation, executionType, opType);
        try {
            this.diskBufferCache.getIOReplicationManager().submitJob((IReplicationJob)job);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public boolean isMemoryComponentsAllocated() {
        return this.memoryComponentsAllocated;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public ILSMMemoryComponent getCurrentMemoryComponent() {
        return this.memoryComponents.get(this.currentMutableComponentId.get());
    }

    @Override
    public int getCurrentMemoryComponentIndex() {
        return this.currentMutableComponentId.get();
    }

    @Override
    public List<ILSMMemoryComponent> getMemoryComponents() {
        return this.memoryComponents;
    }

    protected IBinaryComparatorFactory[] getFilterCmpFactories() {
        return this.filterHelper == null ? null : this.filterHelper.getFilterCmpFactories();
    }

    public int getNumOfFilterFields() {
        return this.filterFields == null ? 0 : this.filterFields.length;
    }

    public double bloomFilterFalsePositiveRate() {
        return this.bloomFilterFalsePositiveRate;
    }

    @Override
    public void updateFilter(ILSMIndexOperationContext ctx, ITupleReference tuple) throws HyracksDataException {
        if (ctx.getFilterTuple() != null && !ctx.isFilterSkipped()) {
            if (ctx.isRecovery()) {
                this.memoryComponents.get(this.currentMutableComponentId.get()).getLSMComponentFilter().update(tuple, ctx.getFilterCmp(), ctx.getModificationCallback());
            } else {
                ctx.getFilterTuple().reset(tuple);
                this.memoryComponents.get(this.currentMutableComponentId.get()).getLSMComponentFilter().update((ITupleReference)ctx.getFilterTuple(), ctx.getFilterCmp(), ctx.getModificationCallback());
            }
        }
    }

    public int[] getFilterFields() {
        return this.filterFields;
    }

    public int[] getTreeFields() {
        return this.treeFields;
    }

    public LSMComponentFilterManager getFilterManager() {
        return this.filterManager;
    }

    @Override
    public ILSMHarness getHarness() {
        return this.lsmHarness;
    }

    public final void validate() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMMemoryComponent iLSMMemoryComponent : this.memoryComponents) {
                iLSMMemoryComponent.validate();
            }
        }
        for (ILSMDiskComponent iLSMDiskComponent : this.diskComponents) {
            iLSMDiskComponent.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCurrentComponentIndex() {
        ILSMOperationTracker iLSMOperationTracker = this.lsmHarness.getOperationTracker();
        synchronized (iLSMOperationTracker) {
            for (ILSMMemoryComponent c : this.memoryComponents) {
                if (c.getReaderCount() > 0) {
                    throw new IllegalStateException("Attempt to reset current component index while readers are inside the components. " + c);
                }
                if (c.getState() == ILSMComponent.ComponentState.INACTIVE) continue;
                throw new IllegalStateException("Attempt to reset current component index while a component is not INACTIVE. " + c);
            }
            this.currentMutableComponentId.set(0);
            this.memoryComponents.get(0);
            try {
                this.memoryComponents.get(0).resetId(null, true);
            }
            catch (HyracksDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public final ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException {
        ILSMIndexAccessor accessor = operation.getAccessor();
        ILSMIndexOperationContext opCtx = accessor.getOpContext();
        ILSMMemoryComponent memoryComponent = (ILSMMemoryComponent)opCtx.getComponentHolder().get(0);
        if (memoryComponent != this.getOldestReadableMemoryComponent()) {
            throw new IllegalStateException("An attempt to flush a memory component that is not the oldest");
        }
        if (!memoryComponent.isModified() || opCtx.getOperation() == IndexOperation.DELETE_COMPONENTS) {
            return EmptyComponent.INSTANCE;
        }
        if (LOGGER.isInfoEnabled()) {
            FlushOperation flushOp = (FlushOperation)operation;
            LOGGER.log(Level.INFO, "Flushing component with id: " + flushOp.getFlushingComponent().getId() + " in the index " + this);
        }
        return this.doFlush(operation);
    }

    @Override
    public final ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException {
        ILSMIndexAccessor accessor = operation.getAccessor();
        ILSMIndexOperationContext opCtx = accessor.getOpContext();
        return opCtx.getOperation() == IndexOperation.DELETE_COMPONENTS ? EmptyComponent.INSTANCE : this.doMerge(operation);
    }

    @Override
    public String getIndexIdentifier() {
        return this.fileManager.getBaseDir().getAbsolutePath();
    }

    public void memoryComponentsReset() {
        this.numScheduledFlushes = Integer.max(0, this.numScheduledFlushes - 1);
    }

    protected abstract LSMComponentFileReferences getMergeFileReferences(ILSMDiskComponent var1, ILSMDiskComponent var2) throws HyracksDataException;

    protected abstract AbstractLSMIndexOperationContext createOpContext(IIndexAccessParameters var1) throws HyracksDataException;

    protected abstract ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext var1, LSMComponentFileReferences var2, ILSMIOOperationCallback var3) throws HyracksDataException;

    protected abstract ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext var1, LSMComponentFileReferences var2, ILSMIOOperationCallback var3) throws HyracksDataException;

    protected abstract ILSMDiskComponent doFlush(ILSMIOOperation var1) throws HyracksDataException;

    protected abstract ILSMDiskComponent doMerge(ILSMIOOperation var1) throws HyracksDataException;

    public Optional<Long> getLatestDiskComponentSequence() {
        if (this.diskComponents.isEmpty()) {
            return Optional.empty();
        }
        ILSMDiskComponent latestDiskComponent = this.diskComponents.get(0);
        Set<String> diskComponentPhysicalFiles = latestDiskComponent.getLSMComponentPhysicalFiles();
        String fileName = (String)diskComponentPhysicalFiles.stream().findAny().orElseThrow(() -> new IllegalStateException("Disk component without any physical files"));
        return Optional.of(IndexComponentFileReference.of(Paths.get(fileName, new String[0]).getFileName().toString()).getSequenceEnd());
    }

    public ILSMPageWriteCallbackFactory getPageWriteCallbackFactory() {
        return this.pageWriteCallbackFactory;
    }
}

