/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.tuples;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriter;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

public class RTreeTypeAwareTupleWriter
extends TypeAwareTupleWriter {
    public RTreeTypeAwareTupleWriter(ITypeTraits[] typeTraits, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) {
        super(typeTraits, nullTypeTraits, nullIntrospector);
    }

    public int writeTupleFields(ITreeIndexTupleReference[] refs, int startField, ByteBuffer targetBuf, int targetOff) {
        int i;
        int runner = targetOff;
        int nullFlagsBytes = this.getNullFlagsBytes(refs.length);
        for (i = 0; i < nullFlagsBytes; ++i) {
            targetBuf.put(runner++, (byte)0);
        }
        for (i = startField; i < startField + refs.length; ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            runner += VarLenIntEncoderDecoder.encode((int)refs[i].getFieldLength(i), (byte[])targetBuf.array(), (int)runner);
        }
        for (i = 0; i < refs.length; ++i) {
            System.arraycopy(refs[i].getFieldData(i), refs[i].getFieldStart(i), targetBuf.array(), runner, refs[i].getFieldLength(i));
            runner += refs[i].getFieldLength(i);
        }
        return runner - targetOff;
    }
}

