/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class RepartitionComputerFactory
implements ITuplePartitionComputerFactory {
    private static final long serialVersionUID = 1L;
    private int factor;
    private ITuplePartitionComputerFactory delegateFactory;

    public RepartitionComputerFactory(int factor, ITuplePartitionComputerFactory delegate) {
        this.factor = factor;
        this.delegateFactory = delegate;
    }

    public ITuplePartitionComputer createPartitioner(final IHyracksTaskContext hyracksTaskContext) {
        return new ITuplePartitionComputer(){
            private ITuplePartitionComputer delegate;
            {
                this.delegate = RepartitionComputerFactory.this.delegateFactory.createPartitioner(hyracksTaskContext);
            }

            public int partition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
                return this.delegate.partition(accessor, tIndex, RepartitionComputerFactory.this.factor * nParts) / RepartitionComputerFactory.this.factor;
            }
        };
    }
}

