/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.spatial;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.apache.asterix.runtime.operators.joins.interval.utils.memory.FrameTupleCursor;
import org.apache.asterix.runtime.operators.joins.interval.utils.memory.RunFilePointer;
import org.apache.asterix.runtime.operators.joins.interval.utils.memory.RunFileStream;
import org.apache.asterix.runtime.operators.joins.interval.utils.memory.TuplePointerCursor;
import org.apache.asterix.runtime.operators.joins.spatial.utils.ISpatialJoinUtil;
import org.apache.asterix.runtime.operators.joins.spatial.utils.memory.SpatialSideTuple;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.buffermanager.DeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.IDeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.IDeletableTupleBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.VariableDeletableTupleMemoryManager;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;

public class SpatialJoiner {
    private final IDeallocatableFramePool framePool;
    private final IDeletableTupleBufferManager bufferManager;
    private final TuplePointerCursor memoryCursor;
    private final LinkedList<TuplePointer> memoryBuffer = new LinkedList();
    private final RunFileStream runFileStream;
    private final RunFilePointer runFilePointer;
    private SpatialSideTuple memoryTuple;
    private SpatialSideTuple[] inputTuple;
    private TuplePointer tp;
    private final ISpatialJoinUtil mjc;
    protected static final int JOIN_PARTITIONS = 2;
    protected static final int BUILD_PARTITION = 0;
    protected static final int PROBE_PARTITION = 1;
    protected final IFrame[] inputBuffer;
    protected final FrameTupleAppender resultAppender;
    protected final FrameTupleCursor[] inputCursor;

    public SpatialJoiner(IHyracksTaskContext ctx, int memorySize, ISpatialJoinUtil mjc, int[] buildKeys, int[] probeKeys, RecordDescriptor buildRd, RecordDescriptor probeRd) throws HyracksDataException {
        this.mjc = mjc;
        if (memorySize < 5) {
            throw new RuntimeException("SpatialJoiner does not have enough memory (needs > 4, got " + memorySize + ").");
        }
        this.inputCursor = new FrameTupleCursor[2];
        this.inputCursor[0] = new FrameTupleCursor(buildRd);
        this.inputCursor[1] = new FrameTupleCursor(probeRd);
        this.inputBuffer = new IFrame[2];
        this.inputBuffer[0] = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.inputBuffer[1] = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.framePool = new DeallocatableFramePool((IHyracksFrameMgrContext)ctx, (memorySize - 4) * ctx.getInitialFrameSize());
        this.bufferManager = new VariableDeletableTupleMemoryManager((IFramePool)this.framePool, probeRd);
        this.memoryCursor = new TuplePointerCursor(this.bufferManager.createTuplePointerAccessor());
        this.runFileStream = new RunFileStream(ctx, "sj-build");
        this.runFilePointer = new RunFilePointer();
        this.runFileStream.createRunFileWriting();
        this.runFileStream.startRunFileWriting();
        this.memoryTuple = new SpatialSideTuple(mjc, this.memoryCursor, probeKeys);
        this.inputTuple = new SpatialSideTuple[2];
        this.inputTuple[1] = new SpatialSideTuple(mjc, this.inputCursor[1], probeKeys);
        this.inputTuple[0] = new SpatialSideTuple(mjc, this.inputCursor[0], buildKeys);
        this.resultAppender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));
    }

    public void processBuildFrame(ByteBuffer buffer) throws HyracksDataException {
        this.inputCursor[0].reset(buffer);
        for (int x = 0; x < this.inputCursor[0].getAccessor().getTupleCount(); ++x) {
            this.runFileStream.addToRunFile(this.inputCursor[0].getAccessor(), x);
        }
    }

    public void processBuildClose() throws HyracksDataException {
        this.runFileStream.flushRunFile();
        this.runFileStream.startReadingRunFile(this.inputCursor[0]);
    }

    public void processProbeFrame(ByteBuffer buffer, IFrameWriter writer) throws HyracksDataException {
        this.inputCursor[1].reset(buffer);
        while (this.buildHasNext() && this.inputCursor[1].hasNext()) {
            if (this.inputCursor[1].hasNext() && this.mjc.checkToLoadNextProbeTuple(this.inputCursor[0].getAccessor(), this.inputCursor[0].getTupleId() + 1, this.inputCursor[1].getAccessor(), this.inputCursor[1].getTupleId() + 1)) {
                this.inputCursor[1].next();
                this.processProbeTuple(writer);
                continue;
            }
            this.inputCursor[0].next();
            this.processBuildTuple(writer);
        }
    }

    public void processProbeClose(IFrameWriter writer) throws HyracksDataException {
        while (this.buildHasNext() && this.memoryHasTuples()) {
            this.inputCursor[0].next();
            this.processBuildTuple(writer);
        }
        this.resultAppender.write(writer, true);
        this.runFileStream.close();
        this.runFileStream.removeRunFile();
    }

    private boolean buildHasNext() throws HyracksDataException {
        if (!this.inputCursor[0].hasNext()) {
            return this.runFileStream.loadNextBuffer(this.inputCursor[0]);
        }
        return true;
    }

    private void processBuildTuple(IFrameWriter writer) throws HyracksDataException {
        if (this.memoryHasTuples()) {
            this.memoryCursor.reset(this.memoryBuffer.iterator());
            while (this.memoryCursor.hasNext()) {
                this.memoryCursor.next();
                if (this.inputTuple[0].removeFromMemory(this.memoryTuple)) {
                    this.bufferManager.deleteTuple(this.memoryCursor.getTuplePointer());
                    this.memoryCursor.remove();
                    continue;
                }
                if (this.inputTuple[0].checkForEarlyExit(this.memoryTuple)) break;
                if (!this.inputTuple[0].compareJoin(this.memoryTuple)) continue;
                this.addToResult(this.inputCursor[0].getAccessor(), this.inputCursor[0].getTupleId(), this.memoryCursor.getAccessor(), this.memoryCursor.getTupleId(), writer);
            }
        }
    }

    private void processProbeTuple(IFrameWriter writer) throws HyracksDataException {
        if (this.mjc.checkToSaveInMemory(this.inputCursor[0].getAccessor(), this.inputCursor[0].getTupleId() + 1, this.inputCursor[1].getAccessor(), this.inputCursor[1].getTupleId()) && !this.addToMemory(this.inputCursor[1].getAccessor(), this.inputCursor[1].getTupleId())) {
            this.unfreezeAndClearMemory(writer);
            if (!this.addToMemory(this.inputCursor[1].getAccessor(), this.inputCursor[1].getTupleId())) {
                throw new RuntimeException("Should Never get called.");
            }
        }
    }

    private void unfreezeAndClearMemory(IFrameWriter writer) throws HyracksDataException {
        this.runFilePointer.reset(this.runFileStream.getReadPointer(), this.inputCursor[0].getTupleId());
        while (this.buildHasNext() && this.memoryHasTuples()) {
            this.inputCursor[0].next();
            this.processBuildTuple(writer);
        }
        this.memoryBuffer.clear();
        this.bufferManager.reset();
        this.runFileStream.startReadingRunFile(this.inputCursor[0], this.runFilePointer.getFileOffset());
        this.inputCursor[0].resetPosition(this.runFilePointer.getTupleIndex());
    }

    private boolean addToMemory(IFrameTupleAccessor accessor, int tupleId) throws HyracksDataException {
        this.tp = new TuplePointer();
        if (this.bufferManager.insertTuple(accessor, tupleId, this.tp)) {
            this.memoryBuffer.add(this.tp);
            return true;
        }
        return false;
    }

    private void addToResult(IFrameTupleAccessor buildAccessor, int buildTupleId, IFrameTupleAccessor probeAccessor, int probeTupleId, IFrameWriter writer) throws HyracksDataException {
        FrameUtils.appendConcatToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.resultAppender, (IFrameTupleAccessor)buildAccessor, (int)buildTupleId, (IFrameTupleAccessor)probeAccessor, (int)probeTupleId);
    }

    private boolean memoryHasTuples() {
        return this.bufferManager.getNumTuples() > 0;
    }
}

