/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.interval.utils;

import org.apache.asterix.om.pointables.nonvisitor.AIntervalPointable;
import org.apache.asterix.runtime.operators.joins.interval.utils.AbstractIntervalJoinUtil;
import org.apache.asterix.runtime.operators.joins.interval.utils.memory.IntervalJoinUtil;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class OverlappingIntervalJoinUtil
extends AbstractIntervalJoinUtil {
    private final long partitionStart;

    public OverlappingIntervalJoinUtil(int buildKey, int probeKey, long partitionStart) {
        super(buildKey, probeKey);
        this.partitionStart = partitionStart;
    }

    @Override
    public boolean checkToSaveInMemory(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) {
        long probeEnd;
        long buildStart = IntervalJoinUtil.getIntervalStart(buildAccessor, buildTupleIndex, this.idBuild);
        return buildStart < (probeEnd = IntervalJoinUtil.getIntervalEnd(probeAccessor, probeTupleIndex, this.idProbe));
    }

    @Override
    public boolean checkForEarlyExit(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) {
        long probeStart = IntervalJoinUtil.getIntervalStart(probeAccessor, probeTupleIndex, this.idProbe);
        long buildEnd = IntervalJoinUtil.getIntervalEnd(buildAccessor, buildTupleIndex, this.idBuild);
        return buildEnd <= probeStart;
    }

    @Override
    public boolean checkToRemoveInMemory(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) {
        long probeEnd;
        long buildStart = IntervalJoinUtil.getIntervalStart(buildAccessor, buildTupleIndex, this.idBuild);
        return buildStart >= (probeEnd = IntervalJoinUtil.getIntervalEnd(probeAccessor, probeTupleIndex, this.idProbe));
    }

    @Override
    public boolean checkToSaveInResult(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) throws HyracksDataException {
        IntervalJoinUtil.getIntervalPointable(buildAccessor, buildTupleIndex, this.idBuild, this.ipBuild);
        IntervalJoinUtil.getIntervalPointable(probeAccessor, probeTupleIndex, this.idProbe, this.ipProbe);
        if (this.ipBuild.getStartValue() < this.partitionStart && this.ipProbe.getStartValue() < this.partitionStart) {
            return false;
        }
        return this.compareInterval(this.ipBuild, this.ipProbe);
    }

    @Override
    public boolean compareInterval(AIntervalPointable ipBuild, AIntervalPointable ipProbe) throws HyracksDataException {
        return this.il.overlapping(ipBuild, ipProbe);
    }
}

