/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.AbstractNumericArithmeticEval;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;

@MissingNullInOutFunction
public class NumericDivideDescriptor
extends AbstractNumericArithmeticEval {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = NumericDivideDescriptor::new;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_DIVIDE;
    }

    @Override
    protected ATypeTag getNumericResultType(ATypeTag argTypeMax) {
        return argTypeMax.ordinal() < ATypeTag.FLOAT.ordinal() ? ATypeTag.DOUBLE : argTypeMax;
    }

    @Override
    protected boolean evaluateDouble(double lhs, double rhs, AMutableDouble result) {
        if (rhs == 0.0) {
            return false;
        }
        double res = lhs / rhs;
        result.setValue(res);
        return true;
    }

    @Override
    protected boolean evaluateInteger(long lhs, long rhs, AMutableInt64 result) {
        throw new IllegalStateException();
    }

    @Override
    protected boolean evaluateTimeDurationArithmetic(long chronon, int yearMonth, long dayTime, boolean isTimeOnly, AMutableInt64 result, IEvaluatorContext ctx) throws HyracksDataException {
        ExceptionUtil.warnUnsupportedType((IEvaluatorContext)ctx, (SourceLocation)this.sourceLoc, (String)this.getIdentifier().getName(), (ATypeTag)ATypeTag.DURATION);
        return false;
    }

    @Override
    protected boolean evaluateTimeInstanceArithmetic(long chronon0, long chronon1, AMutableInt64 result, IEvaluatorContext ctx) throws HyracksDataException {
        ExceptionUtil.warnUnsupportedType((IEvaluatorContext)ctx, (SourceLocation)this.sourceLoc, (String)this.getIdentifier().getName(), (ATypeTag)ATypeTag.TIME);
        return false;
    }
}

