/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABinary;
import org.apache.asterix.om.base.AMutableBinary;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

abstract class AbstractBinaryConstructorEvaluator
extends AbstractConstructorEvaluator {
    protected final AMutableBinary aBinary = new AMutableBinary(new byte[0], 0, 0);
    protected final ISerializerDeserializer<ABinary> binarySerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABINARY);
    protected final UTF8StringPointable utf8Ptr = new UTF8StringPointable();

    protected AbstractBinaryConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case BINARY: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case STRING: {
                this.utf8Ptr.set(this.inputArg.getByteArray(), startOffset + 1, len - 1);
                if (this.parseBinary(this.utf8Ptr, this.aBinary)) {
                    this.resultStorage.reset();
                    this.binarySerde.serialize((Object)this.aBinary, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    @Override
    protected BuiltinType getTargetType() {
        return BuiltinType.ABINARY;
    }

    protected abstract boolean parseBinary(UTF8StringPointable var1, AMutableBinary var2);
}

