/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.INumeric;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.FixedLengthTypeTrait;
import org.apache.hyracks.data.std.util.DataUtils;

public final class LongPointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    private static final int SIZE = 8;
    public static final LongPointableFactory FACTORY = new LongPointableFactory();
    public static final ITypeTraits TYPE_TRAITS = new FixedLengthTypeTrait(8);

    public static long getLong(byte[] bytes, int start) {
        return ((long)(bytes[start] & 0xFF) << 56) + ((long)(bytes[start + 1] & 0xFF) << 48) + ((long)(bytes[start + 2] & 0xFF) << 40) + ((long)(bytes[start + 3] & 0xFF) << 32) + ((long)(bytes[start + 4] & 0xFF) << 24) + ((long)(bytes[start + 5] & 0xFF) << 16) + ((long)(bytes[start + 6] & 0xFF) << 8) + ((long)(bytes[start + 7] & 0xFF) << 0);
    }

    public static void setLong(byte[] bytes, int start, long value) {
        bytes[start] = (byte)(value >>> 56 & 0xFFL);
        bytes[start + 1] = (byte)(value >>> 48 & 0xFFL);
        bytes[start + 2] = (byte)(value >>> 40 & 0xFFL);
        bytes[start + 3] = (byte)(value >>> 32 & 0xFFL);
        bytes[start + 4] = (byte)(value >>> 24 & 0xFFL);
        bytes[start + 5] = (byte)(value >>> 16 & 0xFFL);
        bytes[start + 6] = (byte)(value >>> 8 & 0xFFL);
        bytes[start + 7] = (byte)(value >>> 0 & 0xFFL);
    }

    public long getLong() {
        return LongPointable.getLong(this.bytes, this.start);
    }

    public void setLong(long value) {
        if (this.bytes == null) {
            this.start = 0;
            this.length = TYPE_TRAITS.getFixedLength();
            this.bytes = new byte[this.length];
        }
        LongPointable.setLong(this.bytes, this.start, value);
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        return LongPointable.compare(this.bytes, this.start, this.length, bytes, start, length);
    }

    public static int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        DataUtils.ensureLengths(8, l1, l2);
        return Long.compare(LongPointable.getLong(b1, s1), LongPointable.getLong(b2, s2));
    }

    @Override
    public int hash() {
        long v = this.getLong();
        return (int)(v ^ v >>> 32);
    }

    @Override
    public byte byteValue() {
        return (byte)this.getLong();
    }

    @Override
    public short shortValue() {
        return (short)this.getLong();
    }

    @Override
    public int intValue() {
        return (int)this.getLong();
    }

    @Override
    public long longValue() {
        return this.getLong();
    }

    @Override
    public float floatValue() {
        return this.getLong();
    }

    @Override
    public double doubleValue() {
        return this.getLong();
    }

    public static byte[] toByteArray(long value) {
        byte[] bytes = new byte[8];
        LongPointable.setLong(bytes, 0, value);
        return bytes;
    }

    public static class LongPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        private LongPointableFactory() {
        }

        @Override
        public LongPointable createPointable() {
            return new LongPointable();
        }

        public LongPointable createPointable(long value) {
            LongPointable pointable = new LongPointable();
            pointable.setLong(value);
            return pointable;
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

