/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class CustomerProvidedKey {
    private final ClientLogger logger = new ClientLogger(CustomerProvidedKey.class);
    private final String key;
    private final String keySha256;
    private final EncryptionAlgorithmType encryptionAlgorithm = EncryptionAlgorithmType.AES256;

    public CustomerProvidedKey(String key) {
        MessageDigest sha256;
        this.key = key;
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        byte[] keyhash = sha256.digest(Base64.getDecoder().decode(key));
        this.keySha256 = Base64.getEncoder().encodeToString(keyhash);
    }

    public CustomerProvidedKey(byte[] key) {
        MessageDigest sha256;
        this.key = Base64.getEncoder().encodeToString(key);
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        byte[] keyhash = sha256.digest(key);
        this.keySha256 = Base64.getEncoder().encodeToString(keyhash);
    }

    public String getKey() {
        return this.key;
    }

    public String getKeySha256() {
        return this.keySha256;
    }

    public EncryptionAlgorithmType getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }
}

