/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import org.apache.asterix.dataflow.data.common.ILogicalBinaryComparator;
import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.dataflow.data.nontagged.comparators.LogicalComplexBinaryComparator;
import org.apache.asterix.dataflow.data.nontagged.comparators.LogicalScalarBinaryComparator;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public final class LogicalGenericBinaryComparator
implements ILogicalBinaryComparator {
    private final LogicalComplexBinaryComparator complexComparator;
    private final LogicalScalarBinaryComparator scalarComparator;

    LogicalGenericBinaryComparator(IAType leftType, IAType rightType, boolean isEquality) {
        this.complexComparator = new LogicalComplexBinaryComparator(leftType, rightType, isEquality);
        this.scalarComparator = LogicalScalarBinaryComparator.of(isEquality);
    }

    @Override
    public ILogicalBinaryComparator.Result compare(TaggedValueReference left, TaggedValueReference right) throws HyracksDataException {
        if (left.getTag().isDerivedType() && right.getTag().isDerivedType()) {
            return this.complexComparator.compare(left, right);
        }
        return this.scalarComparator.compare(left, right);
    }

    @Override
    public ILogicalBinaryComparator.Result compare(TaggedValueReference left, IAObject rightConstant) {
        if (left.getTag().isDerivedType() && rightConstant.getType().getTypeTag().isDerivedType()) {
            return this.complexComparator.compare(left, rightConstant);
        }
        return this.scalarComparator.compare(left, rightConstant);
    }

    @Override
    public ILogicalBinaryComparator.Result compare(IAObject leftConstant, TaggedValueReference right) {
        ILogicalBinaryComparator.Result result = this.compare(right, leftConstant);
        if (result == ILogicalBinaryComparator.Result.LT) {
            return ILogicalBinaryComparator.Result.GT;
        }
        if (result == ILogicalBinaryComparator.Result.GT) {
            return ILogicalBinaryComparator.Result.LT;
        }
        return result;
    }

    @Override
    public ILogicalBinaryComparator.Result compare(IAObject leftConst, IAObject rightConst) {
        if (leftConst.getType().getTypeTag().isDerivedType() && rightConst.getType().getTypeTag().isDerivedType()) {
            return this.complexComparator.compare(leftConst, rightConst);
        }
        return this.scalarComparator.compare(leftConst, rightConst);
    }
}

