/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.common;

import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public interface ILogicalBinaryComparator {
    public static Result asResult(int result) {
        return result < 0 ? Result.LT : (result == 0 ? Result.EQ : Result.GT);
    }

    public static boolean inequalityUndefined(ATypeTag tag) {
        switch (tag) {
            case OBJECT: 
            case MULTISET: 
            case DURATION: 
            case INTERVAL: 
            case LINE: 
            case POINT: 
            case POINT3D: 
            case POLYGON: 
            case CIRCLE: 
            case RECTANGLE: {
                return true;
            }
            case UNION: {
                throw new IllegalArgumentException();
            }
        }
        return false;
    }

    public Result compare(TaggedValueReference var1, TaggedValueReference var2) throws HyracksDataException;

    public Result compare(TaggedValueReference var1, IAObject var2);

    public Result compare(IAObject var1, TaggedValueReference var2);

    public Result compare(IAObject var1, IAObject var2);

    public static enum Result {
        MISSING,
        NULL,
        EQ,
        LT,
        GT,
        INCOMPARABLE;

    }
}

