/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.functions.ExternalFunctionCompilerUtil;
import org.apache.asterix.optimizer.rules.SetAsterixPhysicalOperatorsRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ExtractBatchableExternalFunctionCallsRule
implements IAlgebraicRewriteRule {
    private final ExtractFunctionCallsVisitor extractVisitor = new ExtractFunctionCallsVisitor();
    private Boolean isRuleEnabled;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.isRuleEnabled == null) {
            this.isRuleEnabled = SetAsterixPhysicalOperatorsRule.isBatchAssignEnabled(context);
        }
        if (!this.isRuleEnabled.booleanValue()) {
            return false;
        }
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        List assignTopExprRefs = Collections.emptyList();
        switch (op.getOperatorTag()) {
            case ASSIGN: {
                assignTopExprRefs = ((AssignOperator)op).getExpressions();
                break;
            }
            case SELECT: {
                break;
            }
            default: {
                return false;
            }
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        this.extractVisitor.reset(context, assignTopExprRefs);
        if (!op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.extractVisitor)) {
            return false;
        }
        SourceLocation sourceLoc = op.getSourceLocation();
        ILogicalOperator inputOp = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        int ln = this.extractVisitor.assignVars.size();
        for (int i = 0; i < ln; ++i) {
            List<LogicalVariable> assignVarList = this.extractVisitor.assignVars.get(i);
            List<Mutable<ILogicalExpression>> assignExprList = this.extractVisitor.assignExprs.get(i);
            AssignOperator assignOp = new AssignOperator(assignVarList, assignExprList);
            assignOp.setSourceLocation(sourceLoc);
            assignOp.getInputs().add(new MutableObject((Object)inputOp));
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
            assignOp.recomputeSchema();
            OperatorPropertiesUtil.markMovable((ILogicalOperator)assignOp, (boolean)false);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)assignOp);
            for (LogicalVariable assignVar : assignVarList) {
                context.addNotToBeInlinedVar(assignVar);
            }
            inputOp = assignOp;
        }
        op.getInputs().clear();
        op.getInputs().add(new MutableObject((Object)inputOp));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        op.recomputeSchema();
        return true;
    }

    private static final class ExtractFunctionCallsVisitor
    implements ILogicalExpressionReferenceTransform {
        private final List<List<LogicalVariable>> assignVars = new ArrayList<List<LogicalVariable>>();
        private final List<List<Mutable<ILogicalExpression>>> assignExprs = new ArrayList<List<Mutable<ILogicalExpression>>>();
        private final List<LogicalVariable> usedVarList = new ArrayList<LogicalVariable>();
        private IOptimizationContext context;
        private List<Mutable<ILogicalExpression>> dontExtractFromExprRefs;

        private ExtractFunctionCallsVisitor() {
        }

        public void reset(IOptimizationContext context, List<Mutable<ILogicalExpression>> dontExtractFromExprRefs) {
            this.context = context;
            this.dontExtractFromExprRefs = dontExtractFromExprRefs;
            this.assignVars.clear();
            this.assignExprs.clear();
        }

        public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            switch (expr.getExpressionTag()) {
                case FUNCTION_CALL: {
                    IFunctionInfo fnInfo;
                    AbstractFunctionCallExpression callExpr = (AbstractFunctionCallExpression)expr;
                    boolean applied = false;
                    for (Mutable argRef : callExpr.getArguments()) {
                        applied |= this.transform((Mutable<ILogicalExpression>)argRef);
                    }
                    AbstractFunctionCallExpression.FunctionKind fnKind = callExpr.getKind();
                    if (ExternalFunctionCompilerUtil.supportsBatchInvocation((AbstractFunctionCallExpression.FunctionKind)fnKind, (IFunctionInfo)(fnInfo = callExpr.getFunctionInfo())) && callExpr.isFunctional()) {
                        boolean dontExtractExprRef;
                        for (Mutable argRef : callExpr.getArguments()) {
                            ILogicalExpression argExpr = (ILogicalExpression)argRef.getValue();
                            if (argExpr.getExpressionTag() == LogicalExpressionTag.VARIABLE) continue;
                            LogicalVariable newArgVar = this.context.newVar();
                            VariableReferenceExpression newArgVarRef = new VariableReferenceExpression(newArgVar);
                            newArgVarRef.setSourceLocation(expr.getSourceLocation());
                            this.saveAssignVar(newArgVar, argExpr);
                            argRef.setValue((Object)newArgVarRef);
                            applied = true;
                        }
                        boolean bl = dontExtractExprRef = ExtractFunctionCallsVisitor.indexOf(this.dontExtractFromExprRefs, exprRef) >= 0;
                        if (!dontExtractExprRef) {
                            LogicalVariable newVar = this.context.newVar();
                            VariableReferenceExpression newVarRef = new VariableReferenceExpression(newVar);
                            newVarRef.setSourceLocation(expr.getSourceLocation());
                            this.saveAssignVar(newVar, expr);
                            exprRef.setValue((Object)newVarRef);
                            applied = true;
                        }
                    }
                    return applied;
                }
                case VARIABLE: 
                case CONSTANT: {
                    return false;
                }
            }
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, expr.getSourceLocation(), new Serializable[]{expr.getExpressionTag().toString()});
        }

        private void saveAssignVar(LogicalVariable var, ILogicalExpression expr) {
            List<LogicalVariable> assignVarList = null;
            List<Object> assignExprList = null;
            if (!this.assignVars.isEmpty()) {
                this.usedVarList.clear();
                expr.getUsedVariables(this.usedVarList);
                int candidateVarListIdx = this.assignVars.size() - 1;
                List<LogicalVariable> candidateVarList = this.assignVars.get(candidateVarListIdx);
                if (OperatorPropertiesUtil.disjoint(candidateVarList, this.usedVarList)) {
                    assignVarList = candidateVarList;
                    assignExprList = this.assignExprs.get(candidateVarListIdx);
                }
            }
            if (assignVarList == null) {
                assignVarList = new ArrayList<LogicalVariable>();
                assignExprList = new ArrayList<MutableObject>();
                this.assignVars.add(assignVarList);
                this.assignExprs.add(assignExprList);
            }
            assignVarList.add(var);
            assignExprList.add(new MutableObject((Object)expr));
        }

        public static int indexOf(List<Mutable<ILogicalExpression>> exprList, Mutable<ILogicalExpression> exprRef) {
            return OperatorManipulationUtil.indexOf(exprList, (listItemExprRef, paramExprRef) -> listItemExprRef == paramExprRef, exprRef);
        }
    }
}

