/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RunningAggregatePOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPropertiesComputer;
import org.apache.hyracks.algebricks.core.algebra.properties.UnpartitionedPropertyComputer;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class CancelUnnestWithNestedListifyRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        HashSet<LogicalVariable> varSet = new HashSet<LogicalVariable>();
        return this.applyRuleDown(opRef, varSet, context);
    }

    private boolean applyRuleDown(Mutable<ILogicalOperator> opRef, Set<LogicalVariable> varSet, IOptimizationContext context) throws AlgebricksException {
        boolean changed = this.applies(opRef, varSet, context);
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, varSet);
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans aonp = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : aonp.getNestedPlans()) {
                for (Mutable r : p.getRoots()) {
                    if (this.applyRuleDown((Mutable<ILogicalOperator>)r, varSet, context)) {
                        changed = true;
                    }
                    context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)r.getValue());
                }
            }
        }
        for (Mutable i : op.getInputs()) {
            if (this.applyRuleDown((Mutable<ILogicalOperator>)i, varSet, context)) {
                changed = true;
            }
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)i.getValue());
        }
        return changed;
    }

    private boolean applies(Mutable<ILogicalOperator> opRef, Set<LogicalVariable> varUsedAbove, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable unnestedVar;
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnest1 = (UnnestOperator)op1;
        ILogicalExpression expr = (ILogicalExpression)unnest1.getExpressionRef().getValue();
        switch (expr.getExpressionTag()) {
            case VARIABLE: {
                unnestedVar = ((VariableReferenceExpression)expr).getVariableReference();
                break;
            }
            case FUNCTION_CALL: {
                if (((AbstractFunctionCallExpression)expr).getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
                    return false;
                }
                AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)expr;
                ILogicalExpression functionCallArgExpr = (ILogicalExpression)((Mutable)functionCall.getArguments().get(0)).getValue();
                if (functionCallArgExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                    return false;
                }
                unnestedVar = ((VariableReferenceExpression)functionCallArgExpr).getVariableReference();
                break;
            }
            default: {
                return false;
            }
        }
        if (varUsedAbove.contains(unnestedVar)) {
            return false;
        }
        Mutable opRef2 = (Mutable)op1.getInputs().get(0);
        AbstractLogicalOperator r = (AbstractLogicalOperator)opRef2.getValue();
        if (r.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        GroupByOperator gby = (GroupByOperator)r;
        if (gby.getNestedPlans().size() != 1) {
            return false;
        }
        if (((ILogicalPlan)gby.getNestedPlans().get(0)).getRoots().size() != 1) {
            return false;
        }
        AbstractLogicalOperator nestedPlanRoot = (AbstractLogicalOperator)((Mutable)((ILogicalPlan)gby.getNestedPlans().get(0)).getRoots().get(0)).getValue();
        if (nestedPlanRoot.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator agg = (AggregateOperator)nestedPlanRoot;
        Mutable aggInputOpRef = (Mutable)agg.getInputs().get(0);
        if (agg.getVariables().size() > 1) {
            return false;
        }
        if (OperatorManipulationUtil.ancestorOfOperators((ILogicalOperator)agg, (Set)ImmutableSet.of((Object)LogicalOperatorTag.LIMIT, (Object)LogicalOperatorTag.ORDER, (Object)LogicalOperatorTag.GROUP, (Object)LogicalOperatorTag.DISTINCT))) {
            return false;
        }
        LogicalVariable aggVar = (LogicalVariable)agg.getVariables().get(0);
        ILogicalExpression aggFun = (ILogicalExpression)((Mutable)agg.getExpressions().get(0)).getValue();
        if (!aggVar.equals((Object)unnestedVar) || aggFun.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)aggFun;
        if (!BuiltinFunctions.LISTIFY.equals((Object)f.getFunctionIdentifier())) {
            return false;
        }
        if (f.getArguments().size() != 1) {
            return false;
        }
        ILogicalExpression arg0 = (ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue();
        if (arg0.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        LogicalVariable paramVar = ((VariableReferenceExpression)arg0).getVariableReference();
        ArrayList<LogicalVariable> assgnVars = new ArrayList<LogicalVariable>(1);
        assgnVars.add(unnest1.getVariable());
        ArrayList<MutableObject> assgnExprs = new ArrayList<MutableObject>(1);
        VariableReferenceExpression paramRef = new VariableReferenceExpression(paramVar);
        paramRef.setSourceLocation(arg0.getSourceLocation());
        assgnExprs.add(new MutableObject((Object)paramRef));
        AssignOperator assign = new AssignOperator(assgnVars, assgnExprs);
        assign.setSourceLocation(arg0.getSourceLocation());
        LogicalVariable posVar = unnest1.getPositionalVariable();
        if (posVar == null) {
            ArrayList<LogicalVariable> gbyKeyAssgnVars = new ArrayList<LogicalVariable>();
            ArrayList<Mutable> gbyKeyAssgnExprs = new ArrayList<Mutable>();
            for (int i = 0; i < gby.getGroupByList().size(); ++i) {
                if (((Pair)gby.getGroupByList().get((int)i)).first == null) continue;
                gbyKeyAssgnVars.add((LogicalVariable)((Pair)gby.getGroupByList().get((int)i)).first);
                gbyKeyAssgnExprs.add((Mutable)((Pair)gby.getGroupByList().get((int)i)).second);
            }
            Mutable bottomOpRef = aggInputOpRef;
            AbstractLogicalOperator bottomOp = (AbstractLogicalOperator)bottomOpRef.getValue();
            while (bottomOp.getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
                bottomOpRef = (Mutable)bottomOp.getInputs().get(0);
                bottomOp = (AbstractLogicalOperator)bottomOpRef.getValue();
            }
            opRef.setValue((Object)assign);
            assign.getInputs().add(aggInputOpRef);
            AssignOperator gbyKeyAssign = new AssignOperator(gbyKeyAssgnVars, gbyKeyAssgnExprs);
            gbyKeyAssign.setSourceLocation(gby.getSourceLocation());
            gbyKeyAssign.getInputs().add((Mutable)gby.getInputs().get(0));
            bottomOpRef.setValue((Object)gbyKeyAssign);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)gbyKeyAssign);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assign);
        } else {
            ArrayList<LogicalVariable> nestedAssignVars = new ArrayList<LogicalVariable>();
            ArrayList<MutableObject> nestedAssignExprs = new ArrayList<MutableObject>();
            nestedAssignVars.add(unnest1.getVariable());
            nestedAssignExprs.add(new MutableObject((Object)arg0));
            AssignOperator nestedAssign = new AssignOperator(nestedAssignVars, nestedAssignExprs);
            SourceLocation sourceLoc = unnest1.getSourceLocation();
            nestedAssign.setSourceLocation(sourceLoc);
            nestedAssign.getInputs().add(opRef2);
            ArrayList<LogicalVariable> raggVars = new ArrayList<LogicalVariable>();
            ArrayList<MutableObject> raggExprs = new ArrayList<MutableObject>();
            raggVars.add(posVar);
            StatefulFunctionCallExpression fce = new StatefulFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.TID), (IPropertiesComputer)UnpartitionedPropertyComputer.INSTANCE);
            fce.setSourceLocation(sourceLoc);
            raggExprs.add(new MutableObject((Object)fce));
            RunningAggregateOperator raggOp = new RunningAggregateOperator(raggVars, raggExprs);
            raggOp.setSourceLocation(sourceLoc);
            raggOp.setExecutionMode(unnest1.getExecutionMode());
            RunningAggregatePOperator raggPOp = new RunningAggregatePOperator();
            raggOp.setPhysicalOperator((IPhysicalOperator)raggPOp);
            raggOp.getInputs().add((Mutable)nestedPlanRoot.getInputs().get(0));
            ((ILogicalPlan)gby.getNestedPlans().get(0)).getRoots().set(0, new MutableObject((Object)raggOp));
            opRef.setValue((Object)nestedAssign);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)nestedAssign);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)raggOp);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)gby);
        }
        return true;
    }
}

