/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.impl.JavaSerializationBasedPayloadSerializerDeserializer;

public class ExternalFunctionResultRouter
implements IIPCI {
    private final AtomicLong maxId = new AtomicLong(0L);
    private final ConcurrentHashMap<Long, Pair<ByteBuffer, Exception>> activeClients = new ConcurrentHashMap();
    private static int MAX_BUF_SIZE = 0x2000000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverIncomingMessage(IIPCHandle handle, long mid, long rmid, Object payload) {
        int rewind = handle.getAttachmentLen();
        ByteBuffer buf = (ByteBuffer)payload;
        int end = buf.position();
        buf.position(end - rewind);
        Pair<ByteBuffer, Exception> route = this.activeClients.get(rmid);
        ByteBuffer copyTo = (ByteBuffer)route.getFirst();
        if (copyTo.capacity() < handle.getAttachmentLen()) {
            int nextSize = ExternalFunctionResultRouter.closestPow2(handle.getAttachmentLen());
            if (nextSize > MAX_BUF_SIZE) {
                this.onError(handle, mid, rmid, (Exception)HyracksException.create((ErrorCode)ErrorCode.RECORD_IS_TOO_LARGE, (Serializable[])new Serializable[0]));
                return;
            }
            copyTo = ByteBuffer.allocate(nextSize);
            route.setFirst((Object)copyTo);
        }
        copyTo.position(0);
        System.arraycopy(buf.array(), buf.position() + buf.arrayOffset(), copyTo.array(), copyTo.arrayOffset(), handle.getAttachmentLen());
        Pair<ByteBuffer, Exception> pair = route;
        synchronized (pair) {
            copyTo.limit(handle.getAttachmentLen() + 1);
            route.notifyAll();
        }
        buf.position(end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(IIPCHandle handle, long mid, long rmid, Exception exception) {
        Pair<ByteBuffer, Exception> route;
        Pair<ByteBuffer, Exception> pair = route = this.activeClients.get(rmid);
        synchronized (pair) {
            route.setSecond((Object)exception);
            route.notifyAll();
        }
    }

    public Pair<Long, Pair<ByteBuffer, Exception>> insertRoute(ByteBuffer buf) {
        Long id = this.maxId.getAndIncrement();
        Pair bufferHolder = new Pair((Object)buf, null);
        this.activeClients.put(id, (Pair<ByteBuffer, Exception>)bufferHolder);
        return new Pair((Object)id, (Object)bufferHolder);
    }

    public Exception getAndRemoveException(Long id) {
        Pair<ByteBuffer, Exception> route = this.activeClients.get(id);
        Exception e = (Exception)route.getSecond();
        route.setSecond(null);
        return e;
    }

    public void removeRoute(Long id) {
        this.activeClients.remove(id);
    }

    public static int closestPow2(int n) {
        return (int)Math.pow(2.0, Math.ceil(Math.log(n) / Math.log(2.0)));
    }

    public static class NoOpNoSerJustDe
    implements IPayloadSerializerDeserializer {
        private static byte[] noop = new byte[]{0};

        public Object deserializeObject(ByteBuffer buffer, int length, byte flag) throws Exception {
            if (flag == 1) {
                return new JavaSerializationBasedPayloadSerializerDeserializer().deserializeObject(buffer, length, flag);
            }
            return buffer;
        }

        public Exception deserializeException(ByteBuffer buffer, int length) throws Exception {
            return null;
        }

        public byte[] serializeObject(Object object) throws Exception {
            return noop;
        }

        public byte[] serializeException(Exception object) throws Exception {
            return noop;
        }
    }
}

