/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition.range;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITupleMultiPartitionComputer;
import org.apache.hyracks.api.dataflow.value.ITupleMultiPartitionComputerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.dataflow.common.data.partition.range.AbstractFieldRangePartitionComputerFactory;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMapSupplier;

public final class FieldRangeFollowingPartitionComputerFactory
extends AbstractFieldRangePartitionComputerFactory
implements ITupleMultiPartitionComputerFactory {
    private static final long serialVersionUID = 1L;
    private final int[] rangeFields;

    public FieldRangeFollowingPartitionComputerFactory(int[] rangeFields, IBinaryComparatorFactory[] comparatorFactories, RangeMapSupplier rangeMapSupplier, SourceLocation sourceLocation) {
        super(rangeMapSupplier, comparatorFactories, sourceLocation);
        this.rangeFields = rangeFields;
    }

    public ITupleMultiPartitionComputer createPartitioner(IHyracksTaskContext taskContext) {
        return new AbstractFieldRangePartitionComputerFactory.AbstractFieldRangeMultiPartitionComputer(taskContext){

            @Override
            protected int computeStartPartition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
                return this.rangeMapPartitionComputer.partition(accessor, tIndex, FieldRangeFollowingPartitionComputerFactory.this.rangeFields, nParts);
            }

            @Override
            protected int computeEndPartition(IFrameTupleAccessor accessor, int tIndex, int nParts) {
                return nParts - 1;
            }
        };
    }
}

