/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.distribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.distribution.DistributionUtils;
import com.teradata.tpcds.random.RandomNumberStream;
import com.teradata.tpcds.type.Decimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ItemCurrentPriceDistribution {
    private static final int NUM_WEIGHT_FIELDS = 4;
    private static final int NUM_VALUE_FIELDS = 3;
    private static final String VALUES_AND_WEIGHTS_FILENAME = "item_current_price.dst";
    private static final ItemCurrentPriceDistribution I_CURRENT_PRICE_DISTRIBUTION = ItemCurrentPriceDistribution.buildICurrentPriceDistribution();
    private final ImmutableList<Decimal> mins;
    private final ImmutableList<Decimal> maxes;
    private final ImmutableList<ImmutableList<Integer>> weightLists;

    private ItemCurrentPriceDistribution(ImmutableList<Decimal> mins, ImmutableList<Decimal> maxes, ImmutableList<ImmutableList<Integer>> weightLists) {
        this.mins = mins;
        this.maxes = maxes;
        this.weightLists = weightLists;
    }

    private static ItemCurrentPriceDistribution buildICurrentPriceDistribution() {
        ImmutableList.Builder minsBuilder = ImmutableList.builder();
        ImmutableList.Builder maxesBuilder = ImmutableList.builder();
        ArrayList<DistributionUtils.WeightsBuilder> weightsBuilders = new ArrayList<DistributionUtils.WeightsBuilder>(4);
        for (int i = 0; i < 4; ++i) {
            weightsBuilders.add(new DistributionUtils.WeightsBuilder());
        }
        Iterator<List<String>> iterator = DistributionUtils.getDistributionIterator(VALUES_AND_WEIGHTS_FILENAME);
        while (iterator.hasNext()) {
            List<String> fields = iterator.next();
            Preconditions.checkState((fields.size() == 2 ? 1 : 0) != 0, (String)"Expected line to contain 2 parts but it contains %s: %s", (Object[])new Object[]{fields.size(), fields});
            List<String> values = DistributionUtils.getListFromCommaSeparatedValues(fields.get(0));
            Preconditions.checkState((values.size() == 3 ? 1 : 0) != 0, (String)"Expected line to contain %s values, but it contained %s, %s", (Object[])new Object[]{3, values.size(), values});
            minsBuilder.add((Object)Decimal.parseDecimal(values.get(1)));
            maxesBuilder.add((Object)Decimal.parseDecimal(values.get(2)));
            List<String> weights = DistributionUtils.getListFromCommaSeparatedValues(fields.get(1));
            Preconditions.checkState((weights.size() == 4 ? 1 : 0) != 0, (String)"Expected line to contain %s weights, but it contained %s, %s", (Object[])new Object[]{4, weights.size(), weights});
            for (int i = 0; i < weights.size(); ++i) {
                ((DistributionUtils.WeightsBuilder)weightsBuilders.get(i)).computeAndAddNextWeight(Integer.parseInt(weights.get(i)));
            }
        }
        ImmutableList.Builder weightsListBuilder = ImmutableList.builder();
        for (DistributionUtils.WeightsBuilder weightsBuilder : weightsBuilders) {
            weightsListBuilder.add(weightsBuilder.build());
        }
        return new ItemCurrentPriceDistribution((ImmutableList<Decimal>)minsBuilder.build(), (ImmutableList<Decimal>)maxesBuilder.build(), (ImmutableList<ImmutableList<Integer>>)weightsListBuilder.build());
    }

    public static List<Decimal> pickRandomCurrentPriceRange(RandomNumberStream randomNumberStream) {
        int index = DistributionUtils.pickRandomIndex((List)ItemCurrentPriceDistribution.I_CURRENT_PRICE_DISTRIBUTION.weightLists.get(0), randomNumberStream);
        return ImmutableList.of((Object)ItemCurrentPriceDistribution.I_CURRENT_PRICE_DISTRIBUTION.mins.get(index), (Object)ItemCurrentPriceDistribution.I_CURRENT_PRICE_DISTRIBUTION.maxes.get(index));
    }
}

